% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_idea.R
\encoding{UTF-8}
\name{compute_idea}
\alias{compute_idea}
\title{Compute IDEA4 indicators and aggregation metrics}
\usage{
compute_idea(data)
}
\arguments{
\item{data}{an object of class \code{IDEA_items} produced with \code{read_idea()}}
}
\value{
An object of class "IDEA_data" with three attributes :
\describe{
\item{metadata}{a named list containing the 17 metadata entries about the farm}
\item{dataset}{a tibble containing the score computed for the 53 indicators, 13 components and 3 dimensions}
\item{nodes}{a list of tibbles, one per property plus a global one, which all describe the qualitative evaluation obtained for each leaf/node and for the final property.}
}
}
\description{
Aggregates items from \code{read_idea()} to produce IDEA4 indicators, components, dimensions and properties.
}
\details{
This function is designed to compute IDEA scores for the dimensions and properties approaches. A copy of the decision rules used for the properties approach can be locally exported as an excel file with :

\code{IDEATools::show_decision_rules()}

Further information about decision rules can be found in this vignette :

\code{vignette("decision_rules", package = "IDEATools")}
}
\examples{
library(IDEATools)
path <- system.file("example_data/idea_example_1.json", package = "IDEATools")
my_data <- read_idea(path)
computed_data <- compute_idea(my_data)
}
