% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICS_smoothing.R
\name{cics_unif_explicit}
\alias{cics_unif_explicit}
\title{Construct the explicit form of uniform clamped interpolating cubic spline (UcICS).}
\usage{
cics_unif_explicit(
  uumin,
  uumax,
  yy,
  d,
  clrs = c("blue", "red"),
  xlab = NULL,
  ylab = NULL,
  title = NULL
)
}
\arguments{
\item{uumin}{a starting node.}

\item{uumax}{an ending node.}

\item{yy}{a vector of function values pertaining to nodes in \code{uu}.}

\item{d}{a vector of two values of derivative, in the first and the last node of \code{uu}.}

\item{clrs}{a vector (optional parameter) of colours that are used alternately to plot the graph of spline's components.}

\item{xlab}{a title (optional parameter) for the \code{x} axis.}

\item{ylab}{a title (optional parameter) for the \code{y} axis.}

\item{title}{a title (optional parameter) for the plot.}
}
\value{
A list of spline components
\item{spline_coeffs}{matrix, whose \code{i}-th row contains coefficients of uniform ICS's \code{i}-th component.}
\item{spline_polynomials}{list of UcICS's components string representations.}
\item{B}{\code{4}-element array of \code{(n+1)x(n+4)} matrices, whereas element in \code{i}-th row
and \code{j}-th column of \code{l}-th matrix contains coefficient by \code{x^{l-1}} of cubic polynomial that is in \code{i}-th row
and \code{j}-th column of matrix \code{B} from spline's explicit form \deqn{S=B.\gamma.}}
\item{gamma}{\eqn{\gamma=} vector of spline coefficients - function values and exterior-node derivatives that
 takes part in the explicit form \eqn{S=B.\gamma}.}
\item{aux_BF}{A basis function of the spline}
\item{aux_tridiag_inverse}{An inverse of the tridiagonal matrix used for spline derivatives construction}
}
\description{
\code{cics_unif_explicit} constructs the explicit form of uniform clamped interpolating cubic spline
(via Hermite cubic spline) for nodes \code{uu}, function values \code{yy} and exterior-node derivatives
\code{d}.
}
\examples{
yy <- c(4, 5, 2, 1.8);
sp <- cics_unif_explicit(0, 6, yy, c(2, 0.9))
sp$spline_polynomials
### <~~>
### Spline components' coefficients
explicit_spline(sp$B, sp$gamma)
sp$spline_coeffs == .Last.value
}
