% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{as.network.ICON}
\alias{as.network.ICON}
\title{Coerce ICON objects into network objects}
\usage{
\method{as.network}{ICON}(x, directed = FALSE, return_relabeled = FALSE)
}
\arguments{
\item{x}{edgelist of classes `ICON` and `data.frame` to be coerced}

\item{directed}{`TRUE` if network has directed edges; `FALSE` otherwise}

\item{return_relabeled}{nodes are likely to be relabeled to fit naming
conventions of the `network` package; if the names are important, setting
`return_relabeled` to `TRUE` returns the resulting `network` object and
a relabeling key-pair vector}
}
\value{
if `return_relabeled` is `FALSE`, a `network` object; if
  `return_relabeled` is `TRUE`, a `list` containing the `network` object and
  the relabeling key-pair vector
}
\description{
`ICON::get_data` returns data frames that also have class `ICON`. However,
conducting network analysis could require using another R package and its
associated network structure and class. The `as.network.ICON` method is an
S3 generic for the `network::as.network` method and the `ICON` class. It
allows `ICON` users to take full advantage of the functionality provided in
the `network` package using `network` objects.
}
\examples{
\dontrun{
# download dataset using ICON
get_data("aishihik_intensity")

# don't care about relabeled vertices
converted <- as.network(aishihik_intensity, directed = TRUE)

# we care about relabeled vertices
converted2 <- as.network(aishihik_intensity, directed = TRUE,
                        return_relabeled = TRUE)

# get the network
converted_network <- converted2$network

# get the relabeling key-pair vector
converted_relabel <- converted2$labels
}
}
