% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_catalog.R
\name{ReadCatalogInternal}
\alias{ReadCatalogInternal}
\title{Internal read catalog function to be wrapped in a tryCatch}
\usage{
ReadCatalogInternal(
  file,
  ref.genome = NULL,
  region = "unknown",
  catalog.type = "counts"
)
}
\arguments{
\item{file}{Path to a catalog on disk in a standardized format.
The recognized formats are:
\itemize{
\item ICAMS formatted SBS96, SBS192, SBS1536, DBS78, DBS136, DBS144, ID
(see \code{\link{CatalogRowOrder}}).
\item SigProfiler-formatted SBS96, DBS78 and ID83 catalogs;
see \url{https://github.com/AlexandrovLab/SigProfilerExtractor}.
\item COSMIC-formatted SBS96, SBS192 (a.k.a. TSB192),
DBS78, ID83 catalogs;
see \url{https://cancer.sanger.ac.uk/signatures/}.
}}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{region}{region A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}

\item{catalog.type}{One of "counts", "density", "counts.signature",
"density.signature".}
}
\description{
Internal read catalog function to be wrapped in a tryCatch
}
\keyword{internal}
