% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.iblm}
\alias{predict.iblm}
\title{Predict Method for IBLM}
\usage{
\method{predict}{iblm}(object, newdata, trim = NA_real_, type = "response", ...)
}
\arguments{
\item{object}{An object of class 'iblm'. This should be output by `train_iblm_xgb()`}

\item{newdata}{A data frame or matrix containing the predictor variables for
which predictions are desired. Must have the same structure as the
training data used to fit the 'iblm' model.}

\item{trim}{Numeric value for post-hoc truncating of XGBoost predictions. If \code{NA} (default) then no trimming is applied.}

\item{type}{string, defines the type argument used in GLM/Booster Currently only "response" is supported}

\item{...}{additional arguments affecting the predictions produced.}
}
\value{
A numeric vector of ensemble predictions computed as the element-wise
  product of GLM response probabilities and (optionally trimmed) XGBoost
  predictions.
}
\description{
This function generates predictions from an ensemble model consisting of a GLM
and an XGBoost model.
}
\details{
The prediction process involves the following steps:
\enumerate{
  \item Generate GLM predictions
  \item Generate Booster predictions
  \item If trimming is specified, apply to booster predictions
  \item Combine GLM and Booster predictions as per "relationship" described within iblm model object
}

At this point, only an iblm model with a "booster_model" object of class `xgb.Booster` is supported
}
\examples{
data <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  data,
  response_var = "ClaimRate",
  family = "poisson"
)

predictions <- predict(iblm_model, data$test)

predictions |> dplyr::glimpse()

}
\seealso{
\link[stats]{predict.glm}, \link[xgboost]{predict.xgb.Booster}
}
