% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooTp.R
\name{sTp}
\alias{sTp}
\title{Specific Entropy, Function of Temperature and Pressure}
\usage{
sTp(T, p)
}
\arguments{
\item{T}{Temperature [ K ]}

\item{p}{Pressure [ MPa ]}
}
\value{
The Specific Entropy: s [ kJ kg-1 K-1] and an Error message 
    (if an error occur: \link{errorCodes})
}
\description{
The function \code{sTp(T,p)} returns the Specific Entropy, h [ kJ kg-1 K-1 ],
     for given T [K] and D [kg/m3].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
T <- 500.
p <- 10.0003858
sTp(T,p)

}

