% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{summarise}
\alias{summarise}
\alias{summarize}
\alias{summarise.default}
\alias{summarise.formula}
\alias{summarise.data.frame}
\title{Summary statistics for grouped data}
\usage{
summarise(x, ...)

\method{summarise}{default}(
  x,
  y,
  stats = list(Mean = mean, Median = median, `Std. Dev.` = sd, N = length),
  ...
)

\method{summarise}{formula}(
  x,
  data = NULL,
  stats = list(Mean = mean, Median = median, `Std. Dev.` = sd, N = length),
  ...
)

\method{summarise}{data.frame}(x, y, ...)
}
\arguments{
\item{x}{a matrix of multivariate observations, a list of summary statistics from
multivariate observations, a data.frame of multivariate observations, or a formula
with a multivariate response on the right hand side, and a grouping variable/factor
on the left hand side.}

\item{y}{a matrix of multivariate observations, a list of summary statistics from
multivariate observations, OR a data.frame of multivariate observations}

\item{stats}{a named list of summary statistics to compute on each variable in each 
group. Note 1: Quantiles are not supported yet because I can't think of a good way to
handle the extra arguments. Help welcome. Note 2: The names of the elements in the list 
are used to label the columns of the output. They probably should be unique.}

\item{data}{a data.frame containing the variables used in a formula}

\item{\ldots}{other arguments such as another matrix of multivariate observations:
see \code{summarise.default}, or a data to be used with a formula: see
\code{summarise.formula}}
}
\description{
Easily get summary statistics for each group present in the data
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Summary statistics for grouped data

\item \code{formula}: Summary statistics for grouped data

\item \code{data.frame}: Summary statistics for grouped data
}}

\examples{

data(container.df)
split.data = split(container.df[,-1],container.df$gp)
x = split.data[[1]]
y = split.data[[2]]
summarise(x, y)

## Using the formula interface
data(container.df)
summarise(gp~., data = container.df)

summarise(gp~Al+Ti, data = container.df)

}
