% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HmscRandomLevel.R
\name{HmscRandomLevel}
\alias{HmscRandomLevel}
\title{Create an \code{Hmsc} random level}
\usage{
HmscRandomLevel(sData = NULL, sMethod = "Full", distMat = NULL,
  xData = NULL, units = NULL, N = NULL, nNeighbours = NULL,
  sKnot = NULL)
}
\arguments{
\item{sData}{a dataframe containing spatial or temporal coordinates of units of the random level}

\item{sMethod}{a string specifying which spatial method to be used. Possible values are \code{Full}, \code{GPP} and \code{NNGP}}

\item{distMat}{a distance matrix containing the distances between units of the random level}

\item{xData}{a dataframe containing the covariates measured at the units of the random level for covariate-dependent
associations}

\item{units}{a vector, specifying the names of the units of a non-structured level}

\item{N}{number of unique units on this level}

\item{nNeighbours}{a scalar specifying the number of neighbours to be used in case the spatial method is set to \code{NNGP}. Only positive values smaller than the total number of plots are allowed.}

\item{sKnot}{a dataframe containing the knot locations to be used for the gaussian predictive process if sMethod is set to \code{GPP}}
}
\value{
a \code{HmscRandomLevel}-class object that can be used for \code{Hmsc}-class object construction
}
\description{
Specifies the structure of a random factor, including whether the random factor is assumed to
  be spatially explicit or not, the spatial coordinates and the potential structure of covariate-dependent random factors.
}
\details{
Only one of \code{sData}, \code{distMat}, \code{xData}, \code{units} and \code{N} arguments can be
  provided.

  As a good practice, we recommend to specify all available units for a random level, even if some of those are not
  used for training the model.
}
\examples{
# Setting a random level with 50 units
rL = HmscRandomLevel(units=TD$studyDesign$sample)

# Setting a spatial random level
rL = HmscRandomLevel(sData=TD$xycoords)

# Setting a covariate-dependent random level.
rL = HmscRandomLevel(xData=data.frame(x1=rep(1,length(TD$X$x1)),x2=TD$X$x2))

}
\seealso{
[setPriors.Hmsc()]
}
