% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c.Hmsc.R
\name{c.Hmsc}
\alias{c.Hmsc}
\title{Combine Posterior Samples of Several Hmsc Models}
\usage{
\method{c}{Hmsc}(...)
}
\arguments{
\item{...}{Sampled \code{Hmsc} models with posterior samples that
will be added as new chaings in the first listed model.}
}
\value{
An \code{\link{Hmsc}} model with chains of posterior
    samples.
}
\description{
Function combines posterior samples of several sampled
\code{\link{Hmsc}} models (see \code{\link{sampleMcmc}}) as new
chains in the first fitted model. The combined models must be
comparable, and there are some tests for detecting non-equal
models. These tests will only give warning, and it is at user
deliberation to decide which models and which posterior samples can
be combined.  You should be careful not start two models from the
same random number seed, because these will only duplicate your
data instead of providing new independent samples.
}
\examples{
## Fit a toy model with two chains
m1 <- sampleMcmc(TD$m, samples=10, transient=5, nChains=2, verbose=0)
## Need more data? Add chains: check carefully that these are
## sampled exactly like the previous model
m2 <- sampleMcmc(TD$m, nChains=2, samples=10, transient=5, verbose=0)
## Now four chains
m4 <- c(m1, m2)
m4

}
