% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeriTools.R
\name{getReadMatrix.CP}
\alias{getReadMatrix.CP}
\title{Simulate a read matrix from compound Poisson mixed effect models (CPMM).}
\usage{
getReadMatrix.CP(vec.num.rep, alphas, sigma2s, ps, phis)
}
\arguments{
\item{vec.num.rep}{A vector of replicate numbers for each strain.}

\item{alphas}{Intercept vector \eqn{\alpha_g}'s, 
\eqn{1 \times \texttt{num.features}}{1 x num.features}.}

\item{sigma2s}{Random effect variance vector \eqn{\sigma^2_g}'s, 
\eqn{1 \times \texttt{num.features}}{1 x num.features}.}

\item{ps}{Tweedie parameter in CP models, \eqn{p_g}'s, a 
\eqn{1 \times \texttt{num.features}}{1 x num.features} vector.}

\item{phis}{Dispersion parameter in CP models, \eqn{\phi_g}'s, a 
\eqn{1 \times \texttt{num.features}}{1 x num.features} vector.}
}
\value{
A \eqn{G \times N}{G x N} matrix with CP reads. \eqn{N} is the 
  total number of samples; \eqn{G} is the number of features. Column names 
  are sample names of the form "Ss_r", where S stands for sample, s is the 
  strain number, r is the replicate number within the strain. Row names 
  are the feature names of the form "Gene g", where g is the feature index.
}
\description{
Simulate a (possibly unbalanced) read matrix from CPMM.
For a compound Poisson (CP) random variable \eqn{Y_{gsr}} with mean 
\eqn{\mu_{gs}}, its variance can be expressed as 
\eqn{\phi_g\mu_{gs}^{p_g}}, for some \eqn{1<p_g<2}. Under the CPMM, with 
a \eqn{\log}-link, the regression on the mean has the form:\cr
 \eqn{\log(\mu_{gs}) = \alpha_g+ b_{gs}, \;\;b_{gs}\sim N(0, \sigma^2_g).}
}
\examples{
## Generate a sequencing dataset with 5 features and 6 strains. 
## Assign parameter values.
rep.num <- c(3, 5, 2, 3, 4, 2)
a0s <- c(-1, 1, 2, 5, 10)
sig2s <- c(10, 0.2, 0.1, 0.03, 0.01)
ps <- rep(1.5, 5)
phis <- c(1.5, 1, 0.5, 0.1, 0.1)

set.seed(1234)
## Generate reads:
cpData <- getReadMatrix.CP(rep.num, a0s, sig2s, ps, phis)
## Generate strain names:
str <- sapply(1:length(rep.num), function(x){
  str.x <- paste0("S", x)
  return(rep(str.x, rep.num[x]))
})
str <- do.call(c, str)
}

