% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_name.R
\name{show_name}
\alias{show_name}
\title{Show the name of a point}
\usage{
show_name(
  points = NULL,
  x = NULL,
  y = NULL,
  names = NULL,
  col = "red",
  silent = FALSE
)
}
\arguments{
\item{points}{A list with x, y and names elements}

\item{x}{The x coordinates}

\item{y}{The y coordinates.}

\item{names}{The names of the points}

\item{col}{Color of the legend.}

\item{silent}{TRUE or FALSE}
}
\value{
Name of the point
}
\description{
Click on a point in plot region and it will tell you what is the point.
}
\details{
Show the name of a point
}
\examples{
\dontrun{
k <- plot_errbar(1:100, rnorm(100, 1, 2), 
	xlab="axe x", ylab="axe y", bty="n", xlim=c(1,100), 
		errbar.x=2, errbar.y=rnorm(100, 1, 0.1))
show_name(k)
k <- plot_errbar(1:10, rnorm(10, 1, 2), 
	xlab="axe x", ylab="axe y", bty="n", xlim=c(1,10), 
		errbar.x=2, errbar.y=rnorm(10, 1, 0.1), 
		names=LETTERS[1:10])
show_name(k)
k <- plot_errbar(1:10, rnorm(10, 1, 2), 
	xlab="axe x", ylab="axe y", bty="n", xlim=c(1,10), 
		errbar.x=2, errbar.y=rnorm(10, 1, 0.1))
show_name(k, names=LETTERS[1:10])
		}
}
\seealso{
\code{plot_errorbar}

Other plot and barplot functions: 
\code{\link{ScalePreviousPlot}()},
\code{\link{barplot_errbar}()},
\code{\link{plot_add}()},
\code{\link{plot_errbar}()}
}
\author{
Marc Girondot
}
\concept{plot and barplot functions}
