% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractAIC.R
\name{ExtractAIC.glm}
\alias{ExtractAIC.glm}
\title{Return AIC, AICc or BIC from a glm object}
\usage{
ExtractAIC.glm(fit, scale = 0, k = 2, ...)
}
\arguments{
\item{fit}{fitted model, the result of a fitter glm.}

\item{scale}{unused for glm.}

\item{k}{numeric specifying the ‘weight’ of the equivalent degrees of freedom (=: edf) part in the AIC formula.}

\item{...}{further arguments (currently unused because addterm.glm and dropterm.glm using this function do not transmit them).}
}
\value{
A numeric named vector of length 2, with first and second elements giving\cr
edf	the ‘equivalent degrees of freedom’ for the fitted model fit.\cr
x	the Information Criterion for fit.
}
\description{
For glm fits the family's aic() function is used to compute the AIC.\cr
The choice between different criteria is done by setting a global option AIC. It can be checked using show.option=TRUE.
Indeed, it is not possible to use the ... parameter due to a bug in some functions of MASS package. If you want to use this function as a replacement for setpAIC(), do extractAIC.glm <- ExtractAIC.glm before.
}
\details{
ExtractAIC.glm returns AIC, AICc or BIC from a glm object
}
\examples{
extractAIC.glm <- ExtractAIC.glm
n <- 100
x <- rnorm(n, 20, 2)
A <- rnorm(n, 20, 5)
g <- glm(x ~ A)
extractAIC(g, show.option=TRUE)
options(AIC="AIC")
extractAIC(g)
options(AIC="BIC")
extractAIC(g)
options(AIC="AICc")
extractAIC(g)
}
\seealso{
Other AIC: 
\code{\link{compare_AICc}()},
\code{\link{compare_AIC}()},
\code{\link{compare_BIC}()}
}
\author{
Modified from stats:::extract.AIC.glm
}
\concept{AIC}
