% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_kinetics.R
\name{calculate_kinetics}
\alias{calculate_kinetics}
\title{Calculate kinetic data}
\usage{
calculate_kinetics(dat, protein = dat[["Protein"]][1], sequence, state,
  start, end, time_in, time_out)
}
\arguments{
\item{dat}{dat data read by \code{\link{read_hdx}}}

\item{protein}{protein value for chosen peptide}

\item{sequence}{sequence of the peptide for which the kinetics is calculated}

\item{state}{state of given sequence}

\item{start}{end of given sequence}

\item{end}{end of given sequence}

\item{time_in}{time in for experimental calculations}

\item{time_out}{time out for experimental calculations}
}
\value{
data frame with deuteration calculated for all the data points 
between time_in and time_out. 
The chosen time point for which deuteration in all four variants is calculated 
is available in column `time_chosen`. The rest of
the returned structure is equivalent to structure returned by
\code{\link{calculate_state_deuteration}}.
}
\description{
Calculate kinetics of the hydrogen-deuteration exchange 
for given peptide.
}
\details{
The function calculates deuteration data for all available data points 
for given peptide. 
All four variants (relative & theoretical combinations) of deuteration computations 
are supported.
To visualize obtained data we recommend using \code{\link{plot_kinetics}} function.
The first version doesn't support filled Modification and Fragment columns.
}
\examples{
# load example data
dat <- read_hdx(system.file(package = "HaDeX", 
                            "HaDeX/data/KD_180110_CD160_HVEM.csv"))

# calculate data for sequence INITSSASQEGTRLN in state CD160
(kin1 <- calculate_kinetics(dat, 
                   protein = "db_CD160",
                   sequence = "INITSSASQEGTRLN", 
                   state = "CD160",
                   start = 1, 
                   end = 15,
                   time_in = 0.001, 
                   time_out = 1440))
                   
# calculate data for sequence INITSSASQEGTRLN in state CD160_HVEM
(kin2 <- calculate_kinetics(dat, 
                   protein = "db_CD160",
                   sequence = "INITSSASQEGTRLN", 
                   state = "CD160_HVEM",
                   start = 1, 
                   end = 15,
                   time_in = 0.001, 
                   time_out = 1440))
                   
# load extra libraries
library(dplyr)
library(ggplot2)

# plot example - experimental and relative 
bind_rows(kin1, kin2) \%>\% 
 plot_kinetics(theoretical = FALSE, 
               relative = TRUE) +
 labs(title = "Kinetic plot for INITSSASQEGTRLN")
 
# plot example - theoretical and absolute
bind_rows(kin1, kin2) \%>\%
  plot_kinetics(theoretical = TRUE, 
               relative = FALSE) +
  labs(title = "Theoretical kinetics plot for INITSSASQEGTRLN")
       

}
\seealso{
\code{\link{read_hdx}} \code{\link{calculate_state_deuteration}} \code{\link{plot_kinetics}}
}
