% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotQuantErrorHistogram.R
\name{plotQuantErrorHistogram}
\alias{plotQuantErrorHistogram}
\title{Make the quantization error plots for training and scoring.}
\usage{
plotQuantErrorHistogram(hvt.results, hvt.scoring)
}
\arguments{
\item{hvt.results}{List. A list of hvt.results obtained from the trainHVT function.}

\item{hvt.scoring}{List. A list of hvt.scoring obtained from the scoreHVT function.}
}
\value{
Returns the ggplot object containing the quantization error distribution plots for 
the given HVT results of training and scoring
}
\description{
This is the function that produces histograms displaying the distribution of Quantization Error (QE) values 
for both train and test datasets, highlighting mean values with dashed lines for quick evaluation.
}
\examples{
data("EuStockMarkets")
dataset <- data.frame(date = as.numeric(time(EuStockMarkets)),
                     DAX = EuStockMarkets[, "DAX"],
                     SMI = EuStockMarkets[, "SMI"],
                     CAC = EuStockMarkets[, "CAC"],
                     FTSE = EuStockMarkets[, "FTSE"])
rownames(EuStockMarkets) <- dataset$date
#Split in train and test
train <- EuStockMarkets[1:1302, ]
test <- EuStockMarkets[1303:1860, ]

hvt.results<- trainHVT(train,n_cells = 60, depth = 1, quant.err = 0.1,
                      distance_metric = "L1_Norm", error_metric = "max",
                      normalize = TRUE, quant_method = "kmeans")
scoring <- scoreHVT(test, hvt.results)
plotQuantErrorHistogram(hvt.results, scoring) 
}
\seealso{
\code{\link{plotHVT}}
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>
}
\keyword{Diagnostics_or_Validation}
