% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Util.R
\name{phyloseq2df}
\alias{phyloseq2df}
\title{phyloseq data object conversion to data.frame}
\usage{
phyloseq2df(physeq, table_func)
}
\arguments{
\item{physeq}{Phyloseq object}

\item{table_func}{See \code{Phyloseq::phyloseq-class} for options}
}
\value{
data.frame
}
\description{
Conducts conversion of 1 of the data objects
in a phyloseq object (eg., tax_table) to a dataframe
}
\examples{
data(physeq_S2D1)
df_otu = phyloseq2df(physeq_S2D1, table_func=phyloseq::otu_table)
head(df_otu)

df_sample = phyloseq2df(physeq_S2D1, table_func=phyloseq::sample_data)
head(df_sample)

}

