/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import ptolemy.gui.CancelException;

public class MessageHandler {
    private static MessageHandler _handler = new MessageHandler();

    public static void error(String info) {
        _handler._error(info);
    }

    public static void error(String info, Throwable throwable) {
        _handler._error(info, throwable);
    }

    public static String shortDescription(Throwable throwable) {
        String throwableType = null;
        throwableType = throwable instanceof Exception ? "Exception" : (throwable instanceof Error ? "Error" : "Throwable");
        return throwableType;
    }

    public static MessageHandler getMessageHandler() {
        return _handler;
    }

    public static void message(String info) {
        _handler._message(info);
    }

    public static void setMessageHandler(MessageHandler handler) {
        if (handler != null) {
            _handler = handler;
        }
    }

    public static void warning(String info) throws CancelException {
        _handler._warning(info);
    }

    public static void warning(String info, Throwable throwable) throws CancelException {
        _handler._warning(info + ": " + throwable.getMessage(), throwable);
    }

    public static boolean yesNoQuestion(String question) {
        return _handler._yesNoQuestion(question);
    }

    protected void _error(String info) {
        System.err.println(info);
    }

    protected void _error(String info, Throwable throwable) {
        if (throwable instanceof CancelException) {
            return;
        }
        System.err.println(info);
        throwable.printStackTrace();
    }

    protected void _message(String info) {
        System.err.println(info);
    }

    protected void _warning(String info) throws CancelException {
        this._error(info);
    }

    protected void _warning(String info, Throwable throwable) throws CancelException {
        this._error(info, throwable);
    }

    protected boolean _yesNoQuestion(String question) {
        System.out.print(question);
        System.out.print(" (yes or no) ");
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        try {
            String reply = stdIn.readLine();
            if (reply.trim().toLowerCase().equals("yes")) {
                return true;
            }
        }
        catch (IOException ex) {}
        return false;
    }
}

