% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.woa.r
\name{calc.woa}
\alias{calc.woa}
\title{Calculate WOA profile in parallel}
\usage{
calc.woa(pdt, ptt, woa.data = NULL, dateVec, sp.lim = NULL,
  focalDim = NULL, use.se = TRUE)
}
\arguments{
\item{pdt}{input PDT data output from \code{\link{read.wc}} and 
\code{\link{extract.pdt}}}

\item{ptt}{is unique tag identifier}

\item{woa.data}{is (typically) a list of monthly global 1/4deg climatology
data from WOA13. See \code{\link{get.env}}.}

\item{dateVec}{is vector of dates from tag to pop-up in 1 day increments.}

\item{sp.lim}{is list of limits as \code{list(xmin, xmax, ymin, ymax)}}

\item{focalDim}{is integer for dimensions of raster::focal used to calculate 
sd() of temperature grid cell. Recommend focalDim = 3 if woa.data = woa.one
and 9 if using woa.quarter.}

\item{use.se}{is logical indicating whether or not to use SE when using 
regression to predict temperature at specific depth levels.}
}
\value{
raster brick of likelihood
}
\description{
Calculate Depth-temperature profile based likelihood
}
\details{
\code{calc.woa.par} calculates likelihood of animal position based on 
summarized depth-temperature profiles

Tag-based depth-temperature profile summaries are compared to climatological 
profiles from the World Ocean Atlas (WOA) "matched" to generate position
likelihoods. This essentially attempts to estimate animal position based on
the water mass it is in, particularly if extensive diving performs thorough
sampling of the environment. However, remember the in situ data is being
compared to climatological means or the results of an oceanographic model.
}
\seealso{
\code{\link{calc.ohc}}
}
