% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMB-class.R, R/SummaryHMB-class.R
\docType{methods}
\name{show}
\alias{show}
\alias{show,HMB-method}
\alias{show,SummaryHMB-method}
\title{Method show}
\usage{
\S4method{show}{HMB}(object)

\S4method{show}{SummaryHMB}(object)
}
\arguments{
\item{object}{Object of class HMB}
}
\description{
Display model outputs

Display model summary properties
}
\examples{
pop_U  = sample(nrow(HMB_data), 20000)
pop_Sa = sample(pop_U, 5000)
pop_S  = sample(pop_U, 300)

y_S    = HMB_data[pop_S, "GSV"]
X_S    = HMB_data[pop_S, c("hMAX", "h80", "CRR", "pVeg")]
X_Sa   = HMB_data[pop_Sa, c("hMAX", "h80", "CRR", "pVeg")]
Z_Sa   = HMB_data[pop_Sa, c("B20", "B30", "B50")]
Z_U    = HMB_data[pop_U, c("B20", "B30", "B50")]

hmb_model = hmb(y_S, X_S, X_Sa, Z_Sa, Z_U)
show(hmb_model)
pop_U  = sample(nrow(HMB_data), 20000)
pop_Sa = sample(pop_U, 5000)
pop_S  = sample(pop_U, 300)

y_S    = HMB_data[pop_S, "GSV"]
X_S    = HMB_data[pop_S, c("hMAX", "h80", "CRR", "pVeg")]
X_Sa   = HMB_data[pop_Sa, c("hMAX", "h80", "CRR", "pVeg")]
Z_Sa   = HMB_data[pop_Sa, c("B20", "B30", "B50")]
Z_U    = HMB_data[pop_U, c("B20", "B30", "B50")]

hmb_model = hmb(y_S, X_S, X_Sa, Z_Sa, Z_U)
show(summary(hmb_model))
}
