% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneMean.R
\name{oneMean}
\alias{oneMean}
\title{CZZZ-test for one sample mean vector}
\usage{
oneMean(X, m = 2500, filter = TRUE, S = NULL, alpha = 0.05, DNAME)
}
\arguments{
\item{X}{The \eqn{n x p}  data matrix.}

\item{m}{The number of Monte-Carlo samples in the test, default to be \eqn{2500}}

\item{filter}{A logical indicator of the filtering process, defaul to be TRUE}

\item{S}{Covariance matrix of \eqn{X}, if not presented it will be estimated from
the input sample.}

\item{alpha}{The significant level of the test.}

\item{DNAME}{Defaul input.}
}
\value{
Value of testing statistics, p-values (the non-studentized statistic
and the studentized statistic respectively), alternative hypothesis, and the name of testing procedure.
}
\description{
Testing the equality of high dimensional mean vector to zero using the method developed in arXiv:1406.1939 [math.ST]
}
\details{
Implement the method developed in  arXiv:1406.1939 [math.ST] to test whether a high dimensional mean vector is zero or not, which is equivalent
to test \eqn{H_0: \mu=\mu_0} for some prescribed value \eqn{\mu_0} which can be subtracted from the data. The procedure utilizes bootstrap concept and derive the critical values using
independent Gaussian vectors whose covariance is estimated using sample covariance matrix.
}
\author{
Tong He
}
\references{
J. Chang, W. Zhou and W.-X. Zhou, Simulation-Based Hypothesis Testing of High Dimensional Means Under Covariance Heterogeneity (2014), arXiv:1406.1939.
}

