% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deuteration_woods_plots.R
\name{woods_CI_plot}
\alias{woods_CI_plot}
\title{Returns a woods plot for comparisons of the timepoints samples}
\usage{
woods_CI_plot(
  thP,
  th,
  replicates = 3,
  pv_cutoff = 0.01,
  states,
  CI_factor = 1,
  ylim = c(0, 120),
  ...
)
}
\arguments{
\item{thP}{output of output_tcourse_proc() function. Raw data for procent deuteration for time courses}

\item{th}{output of output_tcourse() function. Raw data for uptake deuteration for time courses}

\item{replicates}{number of replicates in sample. Default set to 3.}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}

\item{states}{Protein states from the set. As default all states are chosen.}

\item{CI_factor}{Multiplication factor for Critical Interval. Allows for more restrictive selection of Critial interval.}

\item{ylim}{y axis limit}

\item{...}{other variables}
}
\value{
Woods plots with chosen statistically different peptides
}
\description{
Modification of butterfly plot. x axis residues.
y axis \% deuteration for
Peptides are compared between the sets for the significance change between sets.
If there is significant change beteween sets peptides are plotted for all timepoints.
Significanty different timepoints for the peptides are colored.
Peptides ranges are plotted as a line at corresponding \% deuteration values.
}
\examples{
\donttest{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tc(file_nm)
b<-output_tc(file_nm, percent=TRUE)
woods_CI_plot(thP=b, th=a, pv_cutoff = 0.001, CI_factor = 1, replicates=3)
}
}
