% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDSpatialScan_Classes.R
\name{ResScanOutputMulti}
\alias{ResScanOutputMulti}
\title{Constructor function for objects of the ResScanOutputMulti class}
\usage{
ResScanOutputMulti(
  sites_clusters,
  pval_clusters,
  centres_clusters,
  radius_clusters,
  areas_clusters,
  system,
  variable_names = NULL,
  sites_coord,
  data,
  method
)
}
\arguments{
\item{sites_clusters}{list. List of the indices of the sites of the selected clusters.}

\item{pval_clusters}{numeric vector. The pvalues of the selected clusters.}

\item{centres_clusters}{numeric matrix. Coordinates of the centres of the selected clusters.}

\item{radius_clusters}{numeric vector. Radius of the selected clusters.}

\item{areas_clusters}{numeric vector. Areas of the selected clusters.}

\item{system}{character. System in which the coordinates are expressed: "Euclidean" or "WGS84".}

\item{variable_names}{character. Names of the variables. By default NULL.}

\item{sites_coord}{numeric matrix. Coordinates of the sites (or the individuals, in that case there can be many individuals with the same coordinates).}

\item{data}{matrix. Matrix of the data, the rows correspond to the sites (or to the individuals) and each column represents a variable.}

\item{method}{character. The scan procedure used.}
}
\value{
An object of class ResScanOutputMulti which is a list of the following elements:
\itemize{
\item sites_clusters: List of the indices of the sites of the selected clusters.
\item pval_clusters: The pvalues of the selected clusters.
\item centres_clusters: Coordinates of the centres of the selected clusters.
\item radius_clusters: Radius of the selected clusters.
\item areas_clusters: Areas of the selected clusters.
\item system: System in which the coordinates are expressed: "Euclidean" or "WGS84".
\item sites_coord: Coordinates of the sites (or the individuals, in that case there can be many individuals with the same coordinates).
\item data: Matrix.
\item variable_names: names of the variables.
\item method: The scan procedure used.
}
}
\description{
This is the constructor function for objects of the ResScanOutputMulti class which inherits from class ResScanOutput.
}
