% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_weights_portfol.R
\name{new_GMV_portfolio_weights_BDPS19}
\alias{new_GMV_portfolio_weights_BDPS19}
\title{Constructor of GMV portfolio object.}
\usage{
new_GMV_portfolio_weights_BDPS19(x, b, beta)
}
\arguments{
\item{x}{a p by n matrix or a data frame of asset returns. Rows represent different
assets, columns -- observations.}

\item{b}{a numeric vector. The weights of the target portfolio.}

\item{beta}{a numeric variable. The confidence level for weight intervals.}
}
\value{
an object of class MeanVar_portfolio with subclass GMV_portfolio_weights_BDPS19.\tabular{ll}{
   Element \tab Description \cr
   call \tab the function call with which it was created \cr
   cov_mtrx \tab the sample covariance matrix of the asset returns \cr
   inv_cov_mtrx \tab the inverse of the sample covariance matrix \cr
   means \tab sample mean vector estimate of the asset returns \cr
   w_GMVP \tab sample estimator of portfolio weights \cr
   weights \tab shrinkage estimator of portfolio weights \cr
   alpha \tab shrinkage intensity for the weights \cr
   Port_Var \tab portfolio variance \cr
   Port_mean_return \tab expected portfolio return \cr
   Sharpe \tab portfolio Sharpe ratio \cr
   weight_intervals \tab A data frame, see details \cr
}


weight_intervals contains a shrinkage estimator of portfolio weights,
asymptotic confidence intervals for the true portfolio weights, the value of test
statistic and the p-value of the test on the equality of the weight of each
individual asset to zero \insertCite{@see Section 4.3 of @BDNT21}{HDShOP}.
}
\description{
Constructor of global minimum variance portfolio. For more details of the method,
see \code{\link{MVShrinkPortfolio}}.
}
\examples{

n<-3e2 # number of realizations
p<-.5*n # number of assets
b<-rep(1/p,p)

# Assets with a diagonal covariance matrix
x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)

test <- new_GMV_portfolio_weights_BDPS19(x=x, b=b, beta=0.05)
str(test)

# Assets with a non-diagonal covariance matrix
Mtrx <- RandCovMtrx(p=p)
x <- t(MASS::mvrnorm(n=n , mu=rep(0,p), Sigma=Mtrx))

test <- new_GMV_portfolio_weights_BDPS19(x=x, b=b, beta=0.05)
summary(test)

}
\references{
\insertRef{BDPS2019}{HDShOP}

\insertRef{BPS2018}{HDShOP}

\insertRef{BDNT21}{HDShOP}
}
