% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msca.R
\name{msca}
\alias{msca}
\title{Multilevel Simultaneous Component Analysis - MSCA}
\usage{
msca(formula, data, contrasts = "contr.sum", ...)
}
\arguments{
\item{formula}{Model formula accepting a single response (block) and predictors. See Details for more information.}

\item{data}{The data set to analyse.}

\item{contrasts}{Effect coding: "sum" (default = sum-coding), "weighted", "reference", "treatment".}

\item{...}{Additional arguments to \code{\link{asca_fit}}.}
}
\value{
An \code{asca} object containing loadings, scores, explained variances, etc. The object has
associated plotting (\code{\link{asca_plots}}) and result (\code{\link{asca_results}}) functions.
}
\description{
This MSCA implementation assumes a single factor to be used as between-individuals factor.
}
\examples{
# Load candies data
data(candies)

# Basic MSCA model with a single factor
mod <- msca(assessment ~ candy, data=candies)
print(mod)
summary(mod)

# Result plotting for first factor
loadingplot(mod, scatter=TRUE, labels="names")
scoreplot(mod)

# Within scores
scoreplot(mod, factor="within")

# Within scores per factor level
par.old <- par(mfrow=c(3,2), mar=c(4,4,2,1), mgp=c(2,0.7,0))
for(i in 1:length(mod$scores.within))
  scoreplot(mod, factor="within", within_level=i,
            main=paste0("Level: ", names(mod$scores.within)[i]),
            panel.first=abline(v=0,h=0,col="gray",lty=2))
par(par.old)

# Permutation testing
mod.perm <- asca(assessment ~ candy * assessor, data=candies, permute=TRUE)
summary(mod.perm)

}
\references{
\itemize{
\item Smilde, A., Jansen, J., Hoefsloot, H., Lamers,R., Van Der Greef, J., and Timmerman, M.(2005). ANOVA-Simultaneous Component Analysis (ASCA): A new tool for analyzing designed metabolomics data. Bioinformatics, 21(13), 3043–3048.
\item Liland, K.H., Smilde, A., Marini, F., and Næs,T. (2018). Confidence ellipsoids for ASCA models based on multivariate regression theory. Journal of Chemometrics, 32(e2990), 1–13.
}
}
\seealso{
Main methods: \code{\link{asca}}, \code{\link{apca}}, \code{\link{limmpca}}, \code{\link{msca}}, \code{\link{pcanova}}, \code{\link{prc}} and \code{\link{permanova}}.
Workhorse function underpinning most methods: \code{\link{asca_fit}}.
Extraction of results and plotting: \code{\link{asca_results}}, \code{\link{asca_plots}}, \code{\link{pcanova_results}} and \code{\link{pcanova_plots}}
}
