% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limmpca.R
\name{limmpca}
\alias{limmpca}
\title{Linear Mixed Model PCA}
\usage{
limmpca(
  formula,
  data,
  pca.in = 5,
  aug_error = 0.05,
  use_ED = FALSE,
  REML = TRUE,
  ...
)
}
\arguments{
\item{formula}{Model formula accepting a single response (block) and predictors. See Details for more information.}

\item{data}{The data set to analyse.}

\item{pca.in}{Compress response before ASCA (number of components), default = 5.}

\item{aug_error}{Error term of model ("denominator", "residual", numeric alpha-value).
The latter implies the first with a scaling factor.}

\item{use_ED}{Use Effective Dimensions instead of degrees of freedom when scaling.}

\item{REML}{Use restricted maximum likelihood estimation.
Alternatives: TRUE (default), FALSE (ML), NULL (least squares).}

\item{...}{Additional arguments to \code{\link{asca_fit}}.}
}
\value{
An object of class \code{limmpca}, inheriting from the general \code{asca} class.
}
\description{
This function mimics parts of the LiMM-PCA framework, combining ASCA+ and
linear mixed models to analyse high-dimensional designed data. The default
is to use REML estimation and scaling of the backprojected errors. See examples
for alternatives.
}
\examples{
# Load candies data
data(candies)

# Default LiMM-PCA model with two factors and interaction, 5 PCA components
mod <- limmpca(assessment ~ candy*r(assessor), data=candies)
summary(mod)
scoreplot(mod, factor = "candy")

# LiMM-PCA with least squares estimation and 8 PCA components
modLS <- limmpca(assessment ~ candy*r(assessor), data=candies, REML=NULL, pca.in=8)
summary(modLS)
scoreplot(modLS, factor = "candy")

# Load Caldana data
data(caldana)

# Combining effects in LiMM-PCA (assuming light is a random factor)
mod.comb <- limmpca(compounds ~ time + comb(r(light) + r(time:light)), data=caldana, pca.in=8)
summary(mod.comb)
}
\references{
\itemize{
\item Martin, M. and Govaerts, B. (2020). LiMM-PCA: Combining ASCA+ and linear mixed models to analyse high-dimensional designed data. Journal of Chemometrics, 34(6), e3232.
}
}
\seealso{
Main methods: \code{\link{asca}}, \code{\link{apca}}, \code{\link{limmpca}}, \code{\link{msca}}, \code{\link{pcanova}}, \code{\link{prc}} and \code{\link{permanova}}.
Workhorse function underpinning most methods: \code{\link{asca_fit}}.
Extraction of results and plotting: \code{\link{asca_results}}, \code{\link{asca_plots}}, \code{\link{pcanova_results}} and \code{\link{pcanova_plots}}
}
