% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Temp_model}
\alias{Temp_model}
\title{Altitude gradient base air temperature models}
\usage{
Temp_model(
       model,
       inputData,
       zmeteo,
       ztopo,
       param
)
}
\arguments{
\item{model}{numeric value with model option:
\itemize{
  \item 1: linear air temperature gradient (LT).
  \item 2: linear air temperature gradient with an upper threshold (LTM).
}}

\item{inputData}{numeric vector with air temperature record series [ºC/\eqn{\Delta t}].}

\item{zmeteo}{numeric value indicating the altitude where the air temperature is recorded
\eqn{[masl]}.}

\item{ztopo}{numeric value with the target height \eqn{[masl]}.}

\item{param}{numeric vector with the following parameters:

\strong{LT}
\itemize{
  \item 1: air temperature linear gradient (\code{grad_t}) [ºC/km].
}

\strong{LPM}
\itemize{
  \item 1: air temperature linear gradient (\code{grad_t}) [ºC/km].
  \item 2: threshold height. Air temperature does not decrease when the altitude (\code{ztopo})
  is higher than this value \eqn{[masl]}.
}}
}
\value{
Numeric vector with the extrapolated air temperature series.
}
\description{
Extrapolate air temperature records to another heights. In this package
version you can use the classical linear gradient model or a modified version which
sets an upper altitudinal threshold air temperature decrement (avoiding unreliable estimations).
}
\examples{
# The following is a toy example. I strongly recommend to see
# the package vignettes in order to improve your skills on HBV.IANIGLA

## simple linear model
airTemp <- Temp_model(
                      model = 1,
                      inputData = runif(200, max = 25, min = -10),
                      zmeteo = 2000, ztopo = 3500, param = c(-6.5)
                      )

}
\references{
Immerzeel, W.W., Petersen, L., Ragettli, S., Pellicciotti, F., 2014.
The importance of observed gradients of air temperature and precipitation for modeling
runoff from a glacierized watershed in the Nepalese Himalayas.
Water Resour. Res. 50, 2212–2226. https://doi.org/10.1002/2013WR014506
}
