% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_sl4x.R
\name{load_sl4x}
\alias{load_sl4x}
\title{Load and Process SL4 Files with Enhanced Options}
\usage{
load_sl4x(file_path, lowercase = FALSE, select_header = NULL)
}
\arguments{
\item{file_path}{Character. The full path to the SL4 file to be read.}

\item{lowercase}{Logical. If \code{TRUE}, converts all variable names to lowercase. Default is \code{FALSE}.}

\item{select_header}{Character vector. Specific headers to extract; if \code{NULL}, all headers are read.}
}
\value{
A structured list containing:
\itemize{
\item \code{data}: Extracted SL4 variable data, stored as arrays or matrices.
\item \code{dimension_info}: A list with:
\itemize{
\item \code{dimension_string}: A textual representation of dimensions (e.g., "REG\emph{COMM}YEAR").
\item \code{dimension_names}: The names of each dimension.
\item \code{dimension_sizes}: The size of each dimension.
}
}
}
\description{
Reads an SL4 file and processes its structured data into an enhanced SL4 object.
Extracts structured variable information, dimensions, and handles subtotal columns.
}
\details{
\itemize{
\item Uses \code{load_harplus()} internally for optimized SL4 file reading.
\item Extracts variable names, dimension structures, and metadata.
\item Converts variable names to lowercase if \code{lowercase = TRUE}.
\item Allows the selection of specific headers using \code{select_header}.
\item Returns structured data with explicit dimension names and sizes.
}
}
\examples{
# Path to example files
sl4_path <- system.file("extdata", "TAR10.sl4", package = "HARplus")

# Basic loading
sl4_data <- load_sl4x(sl4_path)

# Load with lowercase names
sl4_data_lower <- load_sl4x(sl4_path, lowercase = TRUE)

# Load specific headers
sl4_selected <- load_sl4x(sl4_path, select_header = c("qo", "qgdp"))

}
\seealso{
\code{\link{load_harx}}, \code{\link{get_data_by_var}}, \code{\link{get_data_by_dims}}
}
\author{
Pattawee Puangchit
}
