% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.H2x2Factorial.R
\name{table.H2x2Factorial}
\alias{table.H2x2Factorial}
\title{H2x2Factorial Table}
\usage{
table.H2x2Factorial(power=0.8, alpha=0.05,
                    pi_x=0.5, pi_z=0.5,
                    delta_x, delta_z, delta_xz, sigma2_y=1,
                    m_bar, CV, rho,
                    test="cluster", correction=FALSE,
                    max_n=1e8, seed_mix=NULL, size_mix=1e4,
                    verbose=TRUE)
}
\arguments{
\item{power}{a numeric value between 0 and 1 as the desired power level for sample size estimation. Default is \code{0.8}.}

\item{alpha}{a numeric value between 0 and 1 as the type I error rate. Default is \code{0.05}.}

\item{pi_x}{a numeric value between 0 and 1 as the proportion of clusters randomized to the cluster-level treatment. Default is \code{0.5}, representing a balanced allocation.}

\item{pi_z}{a numeric value between 0 and 1 as the proportion of individuals randomized to the individual-level treatment within each cluster. Default is \code{0.5}, representing a balanced allocation.}

\item{delta_x}{a nonzero numeric value for the (unstandardized) effect size of the marginal cluster-level treatment effect. Default is \code{0.25}, which is the hypothetical value for the example in the referenced paper.}

\item{delta_z}{a nonzero numeric value for the (unstandardized) effect size of the marginal individual-level treatment effect. Default is \code{0.33}, which is the hypothetical value for the example in the referenced paper.}

\item{delta_xz}{a nonzero numeric value for the (unstandardized) effect size of the interaction effect of the two treatments. Default is \code{0.3}, which is the hypothetical value for the example in the referenced paper.}

\item{sigma2_y}{a positive numeric value for the total variance of the continuous outcome. Default is \code{1}.}

\item{m_bar}{a vector of numeric values larger than 2 for a series of mean cluster sizes.}

\item{CV}{a vector of positive numeric values for a series of coefficients of variation of the cluster sizes.}

\item{rho}{a vector of numeric values between 0 and 1 for a series of intraclass correlation coefficients.}

\item{test}{a character argument indicating the type of hypothesis test of interest. Supported values include
\code{"cluster"} (test for marginal cluster-level treatment effect), \code{"individual"} (test for marginal individual-level treatment effect),
\code{"interaction"} (interaction test for the two treatments), \code{"joint"} (joint test for the two marginal treatment effects),
\code{"I-U"} (intersection-union test for the two marginal effects). Default is \code{"cluster"}.}

\item{correction}{a logical argument indicating whether a finite sample correction should be used. Default is \code{FALSE}.}

\item{max_n}{an optional setting of a maximum number of clusters, which is only functional under \code{test="cluster"}, \code{"joint"}, or \code{"I-U"}. Default is \code{1e8}.}

\item{seed_mix}{an optional setting of a seed for conducting the simulation-based testing under a mixed distribution, which is only functional under \code{test="joint"}. Default is \code{NULL}.}

\item{size_mix}{a pre-specified size for the mixed distribution in the simulation-based procedure, which is only needed under \code{test="joint"}. Default is \code{1e4}.}

\item{verbose}{a logical argument indicating whether the parameter reiterations and supplementary messages should be presented or suppressed. Default is \code{TRUE}.}
}
\value{
\code{table.H2x2Factorial} returns a data frame with inputs of \code{m_bar}, \code{rho}, and \code{CV} varied in a factorial setting, the predicted number of clusters \code{n} under the power requirement,
and the actual power \code{predicted.power} the estimated sample size can help to achieve, with some suppressible messages.
}
\description{
The function \code{table.H2x2Factorial} outputs a data frame that summarizes the required number of clusters and the predicted
power based on a constellation of design parameters. This function is useful when the user wants a series of table-format predictions
based on varying design parameters including mean cluster size (m_bar), intraclass correlation coefficient (rho), and coefficient of variation of the cluster sizes (CV).
}
\details{
If the user further requires a vector of \code{power} or other parameters like \code{pi_x}, which invokes the need for multiple tables,
an external loop could be easily written using this function to produce many data frames.
}
\examples{
#Make a result table by providing three mean cluster sizes, three CV, and three ICC
table.cluster <- table.H2x2Factorial(delta_x=0.2, delta_z=0.1,
                                     m_bar=c(10,50,100), CV=c(0, 0.3, 0.5), rho=c(0.01, 0.1),
                                     test="cluster", verbose=FALSE)
table.cluster

}
