% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.H2x2Factorial.R
\name{calc.H2x2Factorial}
\alias{calc.H2x2Factorial}
\title{H2x2Factorial Sample Size and Power Calculation}
\usage{
calc.H2x2Factorial(power=0.8, n_input=NULL, alpha=0.05,
                   pi_x=0.5, pi_z=0.5,
                   delta_x=0.25, delta_z=0.33, delta_xz=0.3, sigma2_y=1,
                   m_bar=50, CV=0, rho=0,
                   test="cluster", correction=FALSE,
                   max_n=1e8, seed_mix=NULL, size_mix=1e4,
                   verbose=TRUE)
}
\arguments{
\item{power}{a numeric value between 0 and 1 as the desired power level for sample size estimation. Default is \code{0.8}.}

\item{n_input}{a number of cluster provided by the user to estimate the power that can be achieved. Default is \code{NULL}.}

\item{alpha}{a numeric value between 0 and 1 as the type I error rate. Default is \code{0.05}.}

\item{pi_x}{a numeric value between 0 and 1 as the proportion of clusters randomized to the cluster-level treatment. Default is \code{0.5}, representing a balanced allocation.}

\item{pi_z}{a numeric value between 0 and 1 as the proportion of individuals randomized to the individual-level treatment within each cluster. Default is \code{0.5}, representing a balanced allocation.}

\item{delta_x}{a nonzero numeric value for the (unstandardized) effect size of the marginal cluster-level treatment effect. Default is \code{0.25}, which is the hypothetical value for the example in the referenced paper.}

\item{delta_z}{a nonzero numeric value for the (unstandardized) effect size of the marginal individual-level treatment effect. Default is \code{0.33}, which is the hypothetical value for the example in the referenced paper.}

\item{delta_xz}{a nonzero numeric value for the (unstandardized) effect size of the interaction effect of the two treatments. Default is \code{0.3}, which is the hypothetical value for the example in the referenced paper.}

\item{sigma2_y}{a positive numeric value for the total variance of the continuous outcome. Default is \code{1}.}

\item{m_bar}{a numeric value larger than 2 for the mean cluster size. Default is \code{50}.}

\item{CV}{a positive numeric value as the coefficient of variation of the cluster sizes. Default is \code{0}, representing equal cluster sizes.}

\item{rho}{a numeric value between 0 and 1 as the intraclass correlation coefficient characterizing the between-cluster variability. Default is \code{0}.}

\item{test}{a character argument indicating the type of hypothesis test of interest. Supported values include
\code{"cluster"} (test for marginal cluster-level treatment effect), \code{"individual"} (test for marginal individual-level treatment effect),
\code{"interaction"} (interaction test for the two treatments), \code{"joint"} (joint test for the two marginal treatment effects),
\code{"I-U"} (intersection-union test for the two marginal effects). Default is \code{"cluster"}.}

\item{correction}{a logical argument indicating whether a finite sample correction should be used. Default is \code{FALSE}.}

\item{max_n}{an optional setting of a maximum number of clusters, which is only functional under \code{test="cluster"}, \code{"joint"}, or \code{"I-U"}. Default is \code{1e8}.}

\item{seed_mix}{an optional setting of a seed for conducting the simulation-based testing under a mixed distribution, which is only functional under \code{test="joint"}. Default is \code{NULL}.}

\item{size_mix}{a pre-specified size for the mixed distribution in the simulation-based procedure, which is only needed under \code{test="joint"}. Default is \code{1e4}.}

\item{verbose}{a logical argument indicating whether the parameter reiterations and supplementary messages should be presented or suppressed. Default is \code{TRUE}.}
}
\value{
\code{calc.H2x2Factorial} returns an integer representing the required number of clusters or a decimal representing the power that can be achieved by the provided
sample size, with some useful and suppressible messages elaborating vital parameter choices and results (the power will be displayed in 4 decimal places; the messages can be suppressed via \code{verbose=FALSE}).
}
\description{
The function \code{calc.H2x2Factorial} estimates the required number of clusters or the achieved power level under different types of
hypothesis tests in a hierarchical 2x2 factorial trial with unequal cluster sizes and a continuous outcome. Five types of hypothesis tests
as well as their corresponding finite-sample considerations could be chosen for the predictions. Users may input an optional cluster number through the
\code{n.input} argument. When this number is provided, the function will calculate the power under a chosen hypothesis test as well as a
finite-sample correction if specified, and the function will ignore the potential input for the power parameter; When the number of clusters is not
provided, the function will calculate the required number of clusters based on a given power threshold, which is set to 0.8 by default.
}
\details{
Given the input parameters, our method will firstly compute the variances of the effects of interest based on Generalized Least Square estimators and large-sample approximations.
Then, the variances are used to build up either the classic sample size formulas (for the separate tests for marginal treatment effects and the interaction test) or the power formulas (for the simultaneous tests and the corrected tests), which help to deliver both the sample size and power calculations.
Without finite-sample considerations, the two separate tests for marginal treatment effects as well as the interaction test use the two-sided Wald z-test, the joint test use the Chi-square test, and the intersection-union (I-U) test use also a two-sided z-based test.
With \code{correction=T}, finite-sample corrections are customized for the three types of tests involving the marginal cluster-level treatment effect: For the test for marginal cluster-level treatment effect, a two-sided t-test is used;
For the joint test, a simulation-based mixed F-chi-square test is used; For the I-U test, a two-sided mixed t- and z-based test is used.
For the finite-sample corrected joint test, since there does not exist the required parametric distribution, we offer a simulation-based method to generate the null and alternative distributions, and we use the simulated distributions to compute the power and required sample size.
A seed should be set via \code{seed_mix} for this random process to promote reproducibility, and this is only needed under the joint test with finite-sample correction.
The five types of \code{test} and \code{correction} are defined in Tian (under review).
}
\examples{
#Predict the actual power of a joint test when the number of clusters is 10
joint.power <- calc.H2x2Factorial(n_input=10,
                                  delta_x=0.2, delta_z=0.1,
                                  rho=0.1, CV=0.38,
                                  test="joint", correction=TRUE, seed_mix=123456, verbose=FALSE)
print(joint.power)

}
