package de.fhg.iais.kd.djm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;

public class SSHClient {
	private String hostname = null;
	private String username = null;
	private Connection conn = null;
	private String keyPath = null;

	/**
	 * 
	 * @param hostname
	 * @param username
	 * @param key
	 */
	public SSHClient(String hostname, String username, String key) {
		this.hostname = hostname;
		this.username = username;
		keyPath = key;
	}

	public String connect() {
		conn = new Connection(hostname);

		try {
			conn.connect();

			if (conn.isAuthMethodAvailable(username, "publickey")) {
				File key = new File(keyPath);

				if (key.exists()) {
					boolean res = conn.authenticateWithPublicKey(username, key,
							null);

					if (res != true) {
						return("Authentication failed. Please setup a login with RSA Keys and without password");
					}
					else
						return("" + res);
				}
				else
					return("key doesn't exists");
			}
			else
				return("Error, authentication method publickey is not availible on the server");

		} catch (Exception e) {
			e.printStackTrace();
			return("Error, "+ e.getLocalizedMessage());
		}
	}

	public String send(String msg) throws Exception {
		Session sess = conn.openSession();

		sess.execCommand(msg);

		InputStream stdout = new StreamGobbler(sess.getStdout());
		InputStream stderr = new StreamGobbler(sess.getStderr());

		BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
		BufferedReader stderrReader = new BufferedReader(new InputStreamReader(
				stderr));

		String output="";
		while (true) {
			String line = br.readLine();
			if (line == null)
				break;
			output+=line+"\n";
		}

		while (true) {
			String line = stderrReader.readLine();
			if (line == null)
				break;
			output+="Error: " +line+"\n";
		}

		sess.close();
		return output;
	}

	public void upload(String[] from, String to) throws IOException {
		SCPClient client = new SCPClient(conn);
		client.put(from, to);
	}

	public void download(String from, String to) throws IOException {
		SCPClient client = new SCPClient(conn);
		client.get(from, to);
	}

	public void close() {
		/* Close the connection */

		conn.close();
	}
	public Connection getConnection(){
		return conn;
	}

	// public static void main(String[] args)
	// {
	// // for (int i = 0; i < args.length; i++) {
	// // System.out.println(args[i]);
	// // }
	// //Params: args[0] ip
	// // args[1] username
	// // args[2] Path to ssh AuthKey
	// // args[3] localDir
	// // args[4] remotePath
	// // args[5] scriptName
	// // args[6] additional file to upload or "-"
	// // args[7] fName
	// // args[8] yName
	// // args[9] uniqueName
	// // args[10] debug 0/1
	//		
	// if(args.length==11){
	// try {
	// MySSh client = new MySSh(args[0], args[1], args[2]);
	// client.connect();
	// //make remotedir
	// client.send("mkdir -p "+ args[4]);
	// //upload remScriptName, remMainName, fName:
	// String[] up=null;
	// if((args[6]=="" || args[6].equals("-"))){
	// up = new String[]{args[5], args[7]};
	// }
	// else{
	// up = new String[]{args[5], args[6], args[7]};
	// }
	// client.upload(up, args[4]);
	//			
	// //run remote R script (scriptName)
	// client.send("cd " + args[4] + " && R CMD BATCH --vanilla "+ args[5]);
	//
	// //get Rout File
	// client.download(args[4] + args[5]+ "out", args[3]);
	//			
	// //get result (yName)
	// client.download(args[4] + args[8], args[3]);
	//			
	// //delete files on server
	// if(args[10].contains("0")){
	// client.send("cd " + args[4] + "&& rm " + args[9] + "*");
	// }
	// client.close();
	// } catch (Exception e) {
	// e.printStackTrace();
	// //write error to yName in localDir
	// createFileFromString(args[3]+ args[8],"SSH Connection Error:"+
	// e.getMessage());
	// }
	// }
	// else
	// System.out.println("Wrong usage of MySSh.");
	//		
	// }

	private static File createFileFromString(String name, String code) {
		// create file from code

		Writer fw = null;
		try {
			fw = new FileWriter(name);
			fw.write(code);

		} catch (IOException e) {
			System.err.println("Cannot create local File:" + name);

		} finally {
			if (fw != null)
				try {
					fw.close();
				} catch (IOException e) {
				}
		}
		return new File(name);
	}

}
