% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/private_printCaA.R
\name{prCaReorderReferenceDescribe}
\alias{prCaReorderReferenceDescribe}
\title{Adds the ordering, references, and descriptions}
\usage{
prCaReorderReferenceDescribe(x, model, order, var_order, add_references,
  add_references_pos, reference_zero_effect, ds, desc_column, desc_args,
  use_labels)
}
\arguments{
\item{x}{The main value matrix from the \code{\link{prCaPrepareCrudeAndAdjusted}()}}

\item{model}{The model}

\item{order}{A vector A vector with regular expressions for each group.}

\item{var_order}{The output from the \code{\link{prMapVariable2Name}()}}

\item{add_references}{True if it should use the data set to look for 
references, otherwise supply the function with a vector with names. 
Sometimes you want to indicate the reference row for each group. 
This needs to be just as many as the  groups as the order identified. 
Use NA if you don't want to have a reference for that particular group.}

\item{add_references_pos}{The position where a reference should be added. 
Sometimes you don't want the reference to be at the top, for instance 
if you have age groups then you may have < 25, 25-39, 40-55, > 55 and
you have the reference to be 25-39 then you should set the reference 
list for \code{age_groups} as \code{add_references_pos = list(age_groups = 2)}
so that you have the second group as the position for the reference.}

\item{reference_zero_effect}{Used with references, tells if zero effect 
is in exponential form, i.e. \code{exp(0) = 1}, or in regular format, 
i.e. \code{0 = 0} (can be set to any value)}

\item{ds}{The dataset from the model}

\item{desc_column}{Add descriptive column to the crude and adjusted table}

\item{desc_args}{The description arguments that are to be used for the
the description columns. The options/arguments should be generated by the 
\code{\link{caDescribeOpts}} function.}

\item{use_labels}{If the rowname.fn function doesn't change the name then 
the label should be used instead of the name, that is if there is a
label and it isn't a factor.}
}
\value{
The reordered groups as a matrix
}
\description{
This is a wrapper function around some more basic functions that
\code{\link{printCrudeAndAdjustedModel}()} uses.
}
\seealso{
Other printCrudeAndAdjusted functions: \code{\link{prCaAddRefAndStat}},
  \code{\link{prCaAddReference}},
  \code{\link{prCaAddUserReferences}},
  \code{\link{prCaGetImputationCols}},
  \code{\link{prCaGetRowname}},
  \code{\link{prCaGetVnStats}},
  \code{\link{prCaPrepareCrudeAndAdjusted}},
  \code{\link{prCaReorder}},
  \code{\link{prCaSelectAndOrderVars}},
  \code{\link{prCaSetRownames}},
  \code{\link{printCrudeAndAdjustedModel}}
}
\concept{printCrudeAndAdjusted functions}
\keyword{internal}
