% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern_spheretime_warp}
\alias{matern_spheretime_warp}
\alias{d_matern_spheretime_warp}
\title{Deformed Matern covariance function on sphere}
\usage{
matern_spheretime_warp(covparms, lonlattime)

d_matern_spheretime_warp(covparms, lonlattime)
}
\arguments{
\item{covparms}{A vector with covariance parameters
in the form (variance, range_1, range_2, smoothness, nugget, <5 warping parameters>). 
range_1 is a spatial range parameter that assumes that the sphere 
has radius 1 (units are radians). range_2 is a temporal range parameter.}

\item{lonlattime}{A matrix with \code{n} rows and three columns: longitudes in (-180,180),
latitudes in (-90,90), and times.
Each row of lonlattime describes a point on the sphere x time.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{lonlat[i,]} and
\code{lonlat[j,]}.
}
\description{
From a matrix of longitudes, latitudes, times, and a vector covariance parameters of the form
(variance, range_1, range_2, smoothness, nugget, <5 warping parameters>), return the square matrix of
all pairwise covariances.
}
\section{Functions}{
\itemize{
\item \code{d_matern_spheretime_warp}: Derivatives with respect to parameters
}}

\section{Warpings}{

The function first calculates the (x,y,z) 3D coordinates, and then "warps"
the locations to \eqn{(x,y,z) + \Phi(x,y,z)}, where \eqn{\Phi} is a warping
function composed of gradients of spherical harmonic functions of degree 2.
See Guinness (2019, "Gaussian Process Learning via Fisher Scoring of 
Vecchia's Approximation") for details.
The warped locations are input into \code{matern_spacetime}. The function
does not do temporal warping.
}

