% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling.R
\name{preprocess_reviews}
\alias{preprocess_reviews}
\title{Preprocess review text for topic modeling}
\usage{
preprocess_reviews(reviews, english_only = TRUE)
}
\arguments{
\item{reviews}{A data frame containing the scraped reviews}

\item{english_only}{A logical value indicating whether to filter out non-English reviews. Default is TRUE}
}
\value{
A list containing the following elements:
\itemize{
\item \code{corpus}: The preprocessed corpus object.
\item \code{dtm}: The document-term matrix.
\item \code{filtered_reviews}: The filtered reviews data frame.
}
}
\description{
This function preprocesses the review text by optionally filtering non-English reviews,
removing punctuation, converting to lowercase, removing stopwords, and stemming.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Scrape reviews
reviews <- scrape_reviews(temp_file, num_reviews = 5, use_parallel = FALSE)

# Preprocess the reviews
preprocessed <- preprocess_reviews(reviews, english_only = TRUE)

# Print the document-term matrix
print(preprocessed$dtm)

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
