% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_and_has.R
\name{retrieve}
\alias{retrieve}
\title{An R alternative to the lodash \code{get} in JavaScript}
\usage{
retrieve(sourceList, path, default = NA)
}
\arguments{
\item{sourceList}{The \code{list()}/\code{c()} that is to be searched for the element}

\item{path}{A string that can be separated by [,] or ., the string \code{"elementname1.1.elementname"}
is equivalent to \code{"elementname1[[1]]]elementname"}. Note that the function doesn't check
the validity of the path - it only separates and tries to address that element with `[[]]`.}

\item{default}{The value to return if the element isn't found}
}
\value{
Returns a sub-element from \code{sourceList} or the \code{default} value.
}
\description{
This is a handy function for retrieving items deep in a nested structure
without causing error if not found
}
\examples{
source <- list(a = list(b = 1, `odd.name` = 'I hate . in names', c(1,2,3)))
retrieve(source, "a.b")
retrieve(source, "a.b.1")
retrieve(source, "a.odd\\\\.name")
retrieve(source, "a.not_in_list")

}
\seealso{
Other lodash similar functions: 
\code{\link{has}()}
}
\concept{lodash similar functions}
