% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/private_functions.R
\name{prGetStatistics}
\alias{prGetStatistics}
\title{Get statistics according to the type}
\usage{
prGetStatistics(
  x,
  show_perc = FALSE,
  html = TRUE,
  digits = 1,
  digits.nonzero = NA,
  numbers_first = TRUE,
  useNA = c("ifany", "no", "always"),
  useNA.digits = digits,
  show_all_values = FALSE,
  continuous_fn = describeMean,
  factor_fn = describeFactors,
  prop_fn = factor_fn,
  percentage_sign = TRUE
)
}
\arguments{
\item{x}{The variable that you want the statistics for}

\item{html}{If HTML compatible output should be used. If \code{FALSE}
it outputs LaTeX formatting}

\item{digits}{The number of decimals used}

\item{digits.nonzero}{The number of decimals used for values that are close to zero}

\item{numbers_first}{If the number should be given or if the percentage
should be presented first. The second is encapsulated in parentheses ().}

\item{useNA}{This indicates if missing should be added as a separate
row below all other. See \code{\link[base]{table}} for \code{useNA}-options.
\emph{Note:} defaults to ifany and not "no" as \code{\link[base]{table}} does.}

\item{useNA.digits}{The number of digits to use for the
missing percentage, defaults to the overall \code{digits}.}

\item{show_all_values}{This is by default false as for instance if there is
no missing and there is only one variable then it is most sane to only show
one option as the other one will just be a complement to the first. For instance
sex - if you know gender then automatically you know the distribution of the
other sex as it's 100 \% - other \%. To choose which one you want to show then
set the \code{default_ref} parameter.}

\item{continuous_fn}{The method to describe continuous variables. The
default is \code{\link{describeMean}}.}

\item{factor_fn}{The method used to describe factors, see \code{\link{describeFactors}}.}

\item{prop_fn}{The method used to describe proportions, see \code{\link{describeProp}}.}

\item{percentage_sign}{If you want to suppress the percentage sign you
can set this variable to FALSE. You can also choose something else that
the default \% if you so wish by setting this variable.}
}
\value{
A matrix or a vector depending on the settings
}
\description{
A simple function applied by the \code{\link{getDescriptionStatsBy}}
for the total column.
}
\keyword{internal}
