% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssa.etl.diag.R
\name{ssa.etl.diag}
\alias{ssa.etl.diag}
\title{Explicit tau-leap method (ETL) for nu-diagonalized systems}
\usage{
ssa.etl.diag(a, nu_tile, tau)
}
\arguments{
\item{a}{vector of evaluated propensity functions.}

\item{nu_tile}{state-change-matrix.}

\item{tau}{tau-leap.}
}
\value{
A list with two elements:
\itemize{
\item the time leap (\code{tau}) and
\item the realized state change vector (\code{nu_j}).
}
}
\description{
Explicit tau-leap method for nu-diagonalized systems.
}
\details{
Performs one time step using the Explicit tau-leap method. It is usually called from
within \code{\link[=ssa]{ssa()}}, but can be invoked directly, see \code{\link[=ssa.etl]{ssa.etl()}}
for Examples.
}
\seealso{
\code{\link[=ssa.etl]{ssa.etl()}}
}
\keyword{datagen}
\keyword{misc}
\keyword{ts}
