% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gld_get_lattes_data.R
\name{gld_get_lattes_data}
\alias{gld_get_lattes_data}
\title{Downloads and reads Lattes data based on a vector of Lattes ids}
\usage{
gld_get_lattes_data(id.vec, field.qualis = NULL, folder.dl = tempdir())
}
\arguments{
\item{id.vec}{A vector of Lattes ids (e.g. id.vec <- c('K4723925J2', 'K4713546D3') )}

\item{field.qualis}{Area of Qualis to get Qualis journal rankings (default equals NULL). Eg. area.qualis <- 'ECONOMIA'}

\item{folder.dl}{Name of folder where to store xml files (default = tempdir())}
}
\value{
Returns a list with two components:
 \describe{
  \item{tpesq}{A dataframe with information about researchers}
  \item{tpublic}{A dataframe with information about publications}
  \item{tsupervisions}{A dataframe with information about all supervisions}
}
}
\description{
This function downloads xml data directly from Lattes and reads the resulting file, giving as output three dataframes
, a table with description of researchers, list of all publications and a table with completed supervisions
}
\examples{

\dontrun{
l.out <- gld_get_lattes_data(id.vec = 'K4713546D3',
                             field.qualis = 'ECONOMIA')
print(l.out$tpesq)
}
}
