% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghfd_build_lob.R
\name{ghfd_build_lob}
\alias{ghfd_build_lob}
\title{Building LOB (limit order book) from orders}
\usage{
ghfd_build_lob(df.orders, silent = TRUE)
}
\arguments{
\item{df.orders}{A dataframe, output from ghfd_GetHFData}

\item{silent}{Should the function print progress ? (TRUE (default) or FALSE)}
}
\value{
A dataframe with information about LOB
}
\description{
Building LOB (limit order book) from orders
}
\examples{
\dontrun{
library(GetHFData)
first.time <- '11:00:00'
last.time <- '17:00:00'
first.date <- as.Date('2015-11-03')
last.date <- as.Date('2015-11-03')
type.output <- 'raw'
type.data <- 'orders'
type.market = 'equity-odds'

df.out <- ghfd_get_HF_data(my.assets =my.assets,
                          type.market = type.market,
                          type.data = type.data,
                          first.date = first.date,
                          last.date = last.date,
                          first.time = first.time,
                          last.time = last.time,
                          type.output = type.output)
                          
df.lob <- ghfd_build_lob(df.out)
}
}
