% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fplot.R
\name{fplot}
\alias{fplot}
\title{Plot line or bar graphic}
\usage{
fplot(
  data,
  type = "bar",
  x,
  y,
  group = NULL,
  xlab = NULL,
  ylab = NULL,
  glab = NULL,
  ylimits = NULL,
  xrotation = NULL,
  xtext = NULL,
  gtext = NULL,
  legend = "top",
  sig = NULL,
  error = NULL,
  color = TRUE,
  opt = NULL
)
}
\arguments{
\item{data}{Output from ger_testcomp function}

\item{type}{Type of graphic. "bar" or "line"}

\item{x}{Axis x variable}

\item{y}{Axis y variable}

\item{group}{Group variable}

\item{xlab}{Title for the axis x}

\item{ylab}{Title for the axis y}

\item{glab}{Title for the legend}

\item{ylimits}{limits of the y axis}

\item{xrotation}{Rotation in x axis c(angle, h, v)}

\item{xtext}{Text labels in x axis}

\item{gtext}{Text labels in groups}

\item{legend}{the position of legends ("none", "left", "right", "bottom", "top", or two-element numeric vector)}

\item{sig}{Column with the significance}

\item{error}{Show the error bar ("ste" or "std").}

\item{color}{colored figure (TRUE), otherwise black & white (FALSE)}

\item{opt}{Add news layer to the plot}
}
\value{
Line o bar plot
}
\description{
Function use the dtsm function for plot the results
}
\examples{
 

\dontrun{

library(GerminaR)

smr <- ger_summary(SeedN = "seeds"
                   , evalName = "D"
                   , data = prosopis) \%>\%
  mutate(across(rep:temp, as.factor))
  
av <- aov(grp ~ nacl*temp, smr)
anova(av)

mc <- ger_testcomp(aov = av
                   , comp = c("nacl", "temp"))
                   
plotdt <- mc$table
                    
 fplot(data = plotdt
       , type = "line"
       , x = "temp"
       , y = "grp"
       , group = "nacl"
       , sig = "sig"
       , error = "ste"
       , color = F
       , ylimits = c(0, 120, 20)
       , xtext = c(1:5)
       , gtext = c(1:5)
       )
       
 fplot(data = plotdt
       , type = "li"
       , x = "temp"
       , y = "grp"
       , group = "nacl"
       , sig = "sig"
       , error = "ste"
       , color = F
       , ylimits = c(0, 120, 20)
       )
                   
} 

}
