% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNP.R
\name{diff_SNP_tcga}
\alias{diff_SNP_tcga}
\title{Do difference analysis of SNP data downloaded from TCGAbiolinks}
\usage{
diff_SNP_tcga(snpData, sampleType)
}
\arguments{
\item{snpData}{data.frame of SNP data downloaded from TCGAbiolinks}

\item{sampleType}{vector of sample group}
}
\description{
Do difference analysis of SNP data downloaded from TCGAbiolinks
}
\examples{
\dontrun{
library(TCGAbiolinks)
query <- GDCquery(
    project = "TCGA-CHOL", 
    data.category = "Simple Nucleotide Variation", 
    access = "open", 
    legacy = FALSE, 
    data.type = "Masked Somatic Mutation", 
    workflow.type = "Aliquot Ensemble Somatic Variant Merging and Masking"
)
GDCdownload(query)
data_snp <- GDCprepare(query)
samples <- unique(data_snp$Tumor_Sample_Barcode)
sampleType <- sample(c("A","B"), length(samples), replace = TRUE)
names(sampleType) <- samples
pvalue <- diff_SNP_tcga(snpData = data_snp, sampleType = sampleType)
}
}
