% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_genomics.R
\name{Heterozygosity}
\alias{Heterozygosity}
\title{Heterozygosity Rate}
\usage{
Heterozygosity(
  vcf_path,
  batch_size = 10000,
  threads = 1,
  write_log = FALSE,
  logfile = "log.txt",
  window_size = NULL,
  skip_size = NULL,
  exclude_ind = NULL
)
}
\arguments{
\item{vcf_path}{Path to the VCF file.}

\item{batch_size}{The number of variants to be processed in each batch
(used in batch mode only, default of 10,000 should be suitable for most use cases).}

\item{threads}{Number of threads to use for parallel processing.}

\item{write_log}{Logical, indicating whether to write progress logs.}

\item{logfile}{Path to the log file where progress will be logged.}

\item{window_size}{Size of the window for windowed analysis in base pairs (optional).
When specified, \code{skip_size} must also be provided.}

\item{skip_size}{Number of base pairs to skip between windows (optional).
Used in conjunction with \code{window_size} for windowed analysis.}

\item{exclude_ind}{Optional vector of individual IDs to exclude from the analysis.
If provided, the function will remove these individuals from the genotype matrix
before applying the custom function. Default is NULL, meaning no individuals are excluded.}
}
\value{
In batch mode (no window_size or skip_size provided): Observed heterozygosity rate averaged over all loci.
In window mode (window_size and skip_size provided): A data frame with columns 'Chromosome', 'Start', 'End', and 'Ho', representing the observed heterozygosity rate within each window.
}
\description{
This function calculates the rate of heterozygosity for samples in a VCF file. (The proportion of heterozygote genotypes.)
For batch processing, it uses \code{process_vcf_in_batches}. For windowed analysis, it uses a similar
approach tailored to process specific genomic windows (\code{process_vcf_in_windows}).
}
\examples{
\donttest{vcf_file <- system.file("tests/testthat/sim.vcf.gz", package = "GenoPop")
index_file <- system.file("tests/testthat/sim.vcf.gz.tbi", package = "GenoPop")
# Batch mode example
Ho <- Heterozygosity(vcf_file)
# Window mode example
Ho_windows <- Heterozygosity(vcf_file, window_size = 100000, skip_size = 50000)}

}
