% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_genomics.R
\name{FixedSites}
\alias{FixedSites}
\title{FixedSites}
\usage{
FixedSites(
  vcf_path,
  threads = 1,
  write_log = FALSE,
  logfile = "log.txt",
  batch_size = 10000,
  window_size = NULL,
  skip_size = NULL,
  exclude_ind = NULL
)
}
\arguments{
\item{vcf_path}{Path to the VCF file.}

\item{threads}{Number of threads to use for parallel processing.}

\item{write_log}{Logical, indicating whether to write progress logs.}

\item{logfile}{Path to the log file where progress will be logged.}

\item{batch_size}{The number of variants to be processed in each batch
(used in batch mode only, default of 10,000 should be suitable for most use cases).}

\item{window_size}{Size of the window for windowed analysis in base pairs (optional).
When specified, \code{skip_size} must also be provided.}

\item{skip_size}{Number of base pairs to skip between windows (optional).
Used in conjunction with \code{window_size} for windowed analysis.}

\item{exclude_ind}{Optional vector of individual IDs to exclude from the analysis.
If provided, the function will remove these individuals from the genotype matrix
before applying the custom function. Default is NULL, meaning no individuals are excluded.}
}
\value{
In batch mode (no window_size or skip_size provided): A single integer representing the total number of fixed sites for the alternative allele across the entire VCF file.
In window mode (window_size and skip_size provided): A data frame with columns 'Chromosome', 'Start', 'End', and 'FixedSites', representing the count of fixed sites within each window.
}
\description{
This function counts the number of sites fixed for the alternative allele ("1") in a VCF file.
It processes the file in two modes: the entire file at once or in specified windows across the genome.
For batch processing, it uses \code{process_vcf_in_batches}. For windowed analysis, it uses a similar
approach but tailored to process specific genomic windows (\code{process_vcf_in_windows}).
}
\details{
The function has two modes of operation:
\enumerate{
\item Batch Mode: Processes the entire VCF file in batches to count the total number of fixed sites for the alternative allele. Suitable for a general overview of the entire dataset.
\item Window Mode: Processes the VCF file in windows of a specified size and skip distance. This mode is useful for identifying regions with high numbers of fixed sites, which could indicate selective sweeps or regions of low recombination.
}
}
\examples{
\donttest{# Batch mode example
vcf_file <- system.file("tests/testthat/sim.vcf.gz", package = "GenoPop")
index_file <- system.file("tests/testthat/sim.vcf.gz.tbi", package = "GenoPop")
num_fixed_sites <- FixedSites(vcf_file)

# Window mode example
fixed_sites_df <- FixedSites(vcf_file, window_size = 100000, skip_size = 50000)}

}
