%- File: GenSA-package.Rd
%- 
%- Author: sylvain.gubian@pmintl.com
%-
%- This program is distributed in the hope that it will be useful,
%- but WITHOUT ANY WARRANTY; without even the implied warranty of
%- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
%- GNU General Public License for more details.
%-
%-#########################################################################################
\name{GenSA-package}
\alias{GenSA-package}

\docType{package}
\title{
Package for Generalized Simulated Annealing
}
\description{
This package implements a function that searches for global minimum of a very complex non-linear objective function with a very large number of optima. 
Another attractive capability of  this function is that it can automatically handle all types of 
constraints, ranging from the simplest box-constraints to even the most complex non-linear constraints.
}

\details{
\tabular{ll}{
Package: \tab GenSA\cr
Type: \tab Package\cr
Version: \tab 0.99.2\cr
Date: \tab 2011-03-21\cr
License: \tab GPL-2\cr
LazyLoad: \tab yes\cr
}
}

\author{
Yang Xiang, Sylvain Gubian, Brian Suomela, Julia Hoeng, PMP SA.\cr
Maintainer: DL.RSupport@pmi.com
}

\references{
Xiang Y, Gubian S, Suomela B, Hoeng J (2011). "Generalized Simulated Annealing for Efficient Global Optimization: the GenSA Package for R". Journal of Statistical Software, Forthcoming. \url{http://www.jstatsoft.org/}.

Tsallis C (1988). "Possible generalization of Boltzmann-Gibbs statistics." Journal of Statistical Physics, 52, 479--487.

Tsallis C, Stariolo DA (1996). "Generalized Simulated Annealing." Physica A, 233, 395--406.

Xiang Y, Sun DY, Fan W, Gong XG (1997). "Generalized Simulated Annealing Algorithm and Its Application to the Thomson Model." Physics Letters A, 233, 216--220.

Xiang Y, Gong XG (2000a). "Efficiency of Generalized Simulated Annealing." PHYSICAL REVIEW E, 62, 4473.

Xiang Y, Sun DY, Gong XG (2000). "Generalized Simulated Annealing Studies on Structures and Properties of Nin (n=2-55) Clusters." Journal of Physical Chemistry A, 104, 2746--2751.
}


