% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortality_functions.R
\name{DWPbyCarcass}
\alias{DWPbyCarcass}
\title{Assign DWP value to each carcass}
\usage{
DWPbyCarcass(data_DWP, data_CO, unitCol = NULL, sizeCol = NULL,
  DWPCol = NULL)
}
\arguments{
\item{data_DWP}{Survey unit (rows) by size (columns) density weighted 
proportion table}

\item{data_CO}{Carcass observation data}

\item{unitCol}{Column name for the unit indicator (optional). If 
\code{NULL}, then is assumed to be the column that \code{data_DWP} and
\code{data_CO} share. If none are in common, error is thrown with no 
remedy. If data sets share more than one column, user is asked to input 
\code{unitCol}.}

\item{sizeCol}{Name of colum in \code{data_CO} where the size classes
are recorded. Optional.}

\item{DWPCol}{Name of column where DWP values are stored (optional). Used
when there is more than one DWP column in \code{data_DWP} but analysis is
intended for a single class (i.e., no "size" is specified in data_CO).
If \code{sizeCol} is \code{NULL} and \code{DWPCol} is not provided,
there is a check for possible DWPCols. If there is only one column with
values in (0, 1], that's DWPCol. If there is not a unique column with
values in (0, 1], an error is returned.}
}
\value{
DWP value for each carcass
}
\description{
Expand the density weighted proportion table to a value for 
  each carcass (across multiple classes if desired) based on the unit where 
  they were found. (Deprecated. See CO_DWP.)
}
\examples{
 data(mock)
 DWP <- DWPbyCarcass(data_DWP = mock$DWP, data_CO = mock$CO,
          sizeCol = "Size", unitCol = "Unit")
 DWP <- DWPbyCarcass(data_DWP = mock$DWP, data_CO = mock$CO,
          unitCol = "Unit", DWPCol = "S")

}
