% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.formula.R
\name{formula.GeDS}
\alias{formula.GeDS}
\title{Formula for the predictor model}
\usage{
\method{formula}{GeDS}(x, ...)
}
\arguments{
\item{x}{Fitted \code{\link{GeDS-class}} object, tipically produced by
\code{\link{NGeDS}} or \code{\link{GGeDS}} from which the predictor model \code{\link[stats]{formula}} should be extracted.}

\item{...}{Unused in this case.}
}
\description{
A description of the structure of a predictor model to be fitted using  \code{\link{NGeDS}}
and/or \code{\link{GGeDS}} and how this information can be extracted from a \code{\link{GeDS-class}} object.
}
\details{
In the GeDS GNM (GLM) regression, implemented in \code{\link{NGeDS}}
and \code{\link{GGeDS}}, it is assumed that the mean of the response variable transformed using an
appropriate link function is modelled through a possibly multivariate predictor model involving two components:
a GeD variable knot spline regression component involving up to two of the
 independent variables and a parametric component with respect to  the remaining independent variables.
 The formula is used to specify the structure of such a possibly multivariate predictor model.

 The formulae that are input in \code{\link{NGeDS}} and \code{\link{GGeDS}} are similar to those input
 in \code{\link[stats]{lm}} or \code{\link[stats]{glm}} except that the function \code{\link{f}} should be
 specified in order to identify which of the covariates enter the GeD spline regression part
 of the predictor model. For example,  if the predictor model is univariate and it links the transformed means of \code{y}
 to \code{x1}, the predictor has only a GeD spline component and the \code{\link[stats]{formula}}
 should be in the form \code{y ~ f(x1)}.

 As noted, there may be additional independent variables, \code{x2}, \code{x3}, ... which may
enter linearly into the parametric component of the predictor model and not be part of the
GeD spline regression component. For example one may use the formula
\code{y ~ f(x1) + x2 + x3} which assumes a spline regression only between the transformed mean of \code{y}
and \code{x1}, while \code{x2} and \code{x3} enter the predictor model just linearly.

In the current version of the package, \code{\link{GGeDS}} is univariate, therefore only one covariate
which enters the spline regression component can be specified.

In contrast, the function \code{\link{NGeDS}}, generates also bivariate GeDS regression models.
Therefore, if the functional dependence of the mean of the response variable \code{y} on \code{x1} and
 \code{x2} needs to be jointly modelled and there are no other covariates, the formula for the corresponding
 two dimensional predictor model should be specified as \code{y ~ f(x1,x2)}.

 Within the argument \code{formula}, similarly as in other \R functions, it is possible to
 specify one or more offset variables, i.e. known terms with fixed regression coefficients equal to 1.
 These terms should be identified via the function \code{\link[stats]{offset}}.
}

