% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_LatentFactor.R
\docType{class}
\name{LatentFactorKernel}
\alias{LatentFactorKernel}
\title{Latent Factor Kernel R6 class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for fitting GP model.
}
\description{
Latent Factor Kernel R6 class

Latent Factor Kernel R6 class
}
\details{
Used for factor variables, a single dimension.
Each level of the factor gets mapped into a latent space,
then the distances in that space determine their correlations.
}
\examples{
# Create a new kernel for a single factor with 5 levels,
#  mapped into two latent dimensions.
kk <- LatentFactorKernel$new(D=1, nlevels=5, xindex=1, latentdim=2)
# Random initial parameter values
kk$p
# Plots to understand
kk$plotLatent()
kk$plot()


# 5 levels, 1/4 are similar and 2/3/5 are similar
n <- 30
x <- matrix(sample(1:5, n, TRUE))
y <- c(ifelse(x == 1 | x == 4, 4, -3) + rnorm(n,0,.1))
plot(c(x), y)
m5 <- GauPro_kernel_model$new(
  X=x, Z=y,
  kernel=LatentFactorKernel$new(D=1, nlevels = 5, xindex = 1, latentdim = 2))
m5$kernel$p
# We should see 1/4 and 2/3/4 in separate clusters
m5$kernel$plotLatent()

library(dplyr)
n <- 20
X <- cbind(matrix(runif(n,2,6), ncol=1),
           matrix(sample(1:2, size=n, replace=TRUE), ncol=1))
X <- rbind(X, c(3.3,3), c(3.7,3))
n <- nrow(X)
Z <- X[,1] - (4-X[,2])^2 + rnorm(n,0,.1)
plot(X[,1], Z, col=X[,2])
tibble(X=X, Z) \%>\% arrange(X,Z)
k2a <- IgnoreIndsKernel$new(k=Gaussian$new(D=1), ignoreinds = 2)
k2b <- LatentFactorKernel$new(D=2, nlevels=3, xind=2, latentdim=2)
k2 <- k2a * k2b
k2b$p_upper <- .65*k2b$p_upper
gp <- GauPro_kernel_model$new(X=X, Z=Z, kernel = k2, verbose = 5,
  nug.min=1e-2, restarts=1)
gp$kernel$k1$kernel$beta
gp$kernel$k2$p
gp$kernel$k(x = gp$X)
tibble(X=X, Z=Z, pred=gp$predict(X)) \%>\% arrange(X, Z)
tibble(X=X[,2], Z) \%>\% group_by(X) \%>\% summarize(n=n(), mean(Z))
curve(gp$pred(cbind(matrix(x,ncol=1),1)),2,6, ylim=c(min(Z), max(Z)))
points(X[X[,2]==1,1], Z[X[,2]==1])
curve(gp$pred(cbind(matrix(x,ncol=1),2)), add=TRUE, col=2)
points(X[X[,2]==2,1], Z[X[,2]==2], col=2)
curve(gp$pred(cbind(matrix(x,ncol=1),3)), add=TRUE, col=3)
points(X[X[,2]==3,1], Z[X[,2]==3], col=3)
legend(legend=1:3, fill=1:3, x="topleft")
# See which points affect (5.5, 3 themost)
data.frame(X, cov=gp$kernel$k(X, c(5.5,3))) \%>\% arrange(-cov)
plot(k2b)
}
\references{
https://stackoverflow.com/questions/27086195/linear-index-upper-triangular-matrix
}
\section{Super class}{
\code{\link[GauPro:GauPro_kernel]{GauPro::GauPro_kernel}} -> \code{GauPro_kernel_LatentFactorKernel}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{p}}{Parameter for correlation}

\item{\code{p_est}}{Should p be estimated?}

\item{\code{p_lower}}{Lower bound of logp}

\item{\code{p_upper}}{Upper bound of logp}

\item{\code{p_length}}{length of p}

\item{\code{s2}}{variance}

\item{\code{s2_est}}{Is s2 estimated?}

\item{\code{logs2}}{Log of s2}

\item{\code{logs2_lower}}{Lower bound of logs2}

\item{\code{logs2_upper}}{Upper bound of logs2}

\item{\code{xindex}}{Index of the factor (which column of X)}

\item{\code{nlevels}}{Number of levels for the factor}

\item{\code{latentdim}}{Dimension of embedding space}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GauPro_kernel_LatentFactorKernel-new}{\code{LatentFactorKernel$new()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-k}{\code{LatentFactorKernel$k()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-kone}{\code{LatentFactorKernel$kone()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-dC_dparams}{\code{LatentFactorKernel$dC_dparams()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-C_dC_dparams}{\code{LatentFactorKernel$C_dC_dparams()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-dC_dx}{\code{LatentFactorKernel$dC_dx()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-param_optim_start}{\code{LatentFactorKernel$param_optim_start()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-param_optim_start0}{\code{LatentFactorKernel$param_optim_start0()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-param_optim_lower}{\code{LatentFactorKernel$param_optim_lower()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-param_optim_upper}{\code{LatentFactorKernel$param_optim_upper()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-set_params_from_optim}{\code{LatentFactorKernel$set_params_from_optim()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-s2_from_params}{\code{LatentFactorKernel$s2_from_params()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-plot}{\code{LatentFactorKernel$plot()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-plotLatent}{\code{LatentFactorKernel$plotLatent()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-print}{\code{LatentFactorKernel$print()}}
\item \href{#method-GauPro_kernel_LatentFactorKernel-clone}{\code{LatentFactorKernel$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-new"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-new}{}}}
\subsection{Method \code{new()}}{
Initialize kernel object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$new(
  s2 = 1,
  D,
  nlevels,
  xindex,
  latentdim,
  p_lower = 0,
  p_upper = 1,
  p_est = TRUE,
  s2_lower = 1e-08,
  s2_upper = 1e+08,
  s2_est = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s2}}{Initial variance}

\item{\code{D}}{Number of input dimensions of data}

\item{\code{nlevels}}{Number of levels for the factor}

\item{\code{xindex}}{Index of X to use the kernel on}

\item{\code{latentdim}}{Dimension of embedding space}

\item{\code{p_lower}}{Lower bound for p}

\item{\code{p_upper}}{Upper bound for p}

\item{\code{p_est}}{Should p be estimated?}

\item{\code{s2_lower}}{Lower bound for s2}

\item{\code{s2_upper}}{Upper bound for s2}

\item{\code{s2_est}}{Should s2 be estimated?}

\item{\code{p}}{Periodic parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-k"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-k}{}}}
\subsection{Method \code{k()}}{
Calculate covariance between two points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$k(x, y = NULL, p = self$p, s2 = self$s2, params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector.}

\item{\code{y}}{vector, optional. If excluded, find correlation
of x with itself.}

\item{\code{p}}{Correlation parameters.}

\item{\code{s2}}{Variance parameter.}

\item{\code{params}}{parameters to use instead of beta and s2.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-kone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-kone}{}}}
\subsection{Method \code{kone()}}{
Find covariance of two points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$kone(x, y, pf, s2, isdiag = TRUE, offdiagequal = 1 - 1e-06)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector}

\item{\code{y}}{vector}

\item{\code{pf}}{correlation parameters on regular scale, includes zeroes
for first level.}

\item{\code{s2}}{Variance parameter}

\item{\code{isdiag}}{Is this on the diagonal of the covariance?}

\item{\code{offdiagequal}}{What should offdiagonal values be set to when the
indices are the same? Use to avoid decomposition errors, similar to
adding a nugget.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-dC_dparams"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-dC_dparams}{}}}
\subsection{Method \code{dC_dparams()}}{
Derivative of covariance with respect to parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$dC_dparams(params = NULL, X, C_nonug, C, nug)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Kernel parameters}

\item{\code{X}}{matrix of points in rows}

\item{\code{C_nonug}}{Covariance without nugget added to diagonal}

\item{\code{C}}{Covariance with nugget}

\item{\code{nug}}{Value of nugget}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-C_dC_dparams"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-C_dC_dparams}{}}}
\subsection{Method \code{C_dC_dparams()}}{
Calculate covariance matrix and its derivative
 with respect to parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$C_dC_dparams(params = NULL, X, nug)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Kernel parameters}

\item{\code{X}}{matrix of points in rows}

\item{\code{nug}}{Value of nugget}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-dC_dx"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-dC_dx}{}}}
\subsection{Method \code{dC_dx()}}{
Derivative of covariance with respect to X
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$dC_dx(
  XX,
  X,
  logp = self$logp,
  logalpha = self$logalpha,
  s2 = self$s2
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{XX}}{matrix of points}

\item{\code{X}}{matrix of points to take derivative with respect to}

\item{\code{logp}}{log of p}

\item{\code{logalpha}}{log of alpha}

\item{\code{s2}}{Variance parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-param_optim_start"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-param_optim_start}{}}}
\subsection{Method \code{param_optim_start()}}{
Starting point for parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$param_optim_start(
  jitter = F,
  y,
  p_est = self$p_est,
  s2_est = self$s2_est
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jitter}}{Should there be a jitter?}

\item{\code{y}}{Output}

\item{\code{p_est}}{Is p being estimated?}

\item{\code{s2_est}}{Is s2 being estimated?}

\item{\code{alpha_est}}{Is alpha being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-param_optim_start0"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-param_optim_start0}{}}}
\subsection{Method \code{param_optim_start0()}}{
Starting point for parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$param_optim_start0(
  jitter = F,
  y,
  p_est = self$p_est,
  s2_est = self$s2_est
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jitter}}{Should there be a jitter?}

\item{\code{y}}{Output}

\item{\code{p_est}}{Is p being estimated?}

\item{\code{s2_est}}{Is s2 being estimated?}

\item{\code{alpha_est}}{Is alpha being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-param_optim_lower"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-param_optim_lower}{}}}
\subsection{Method \code{param_optim_lower()}}{
Lower bounds of parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$param_optim_lower(p_est = self$p_est, s2_est = self$s2_est)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p_est}}{Is p being estimated?}

\item{\code{s2_est}}{Is s2 being estimated?}

\item{\code{alpha_est}}{Is alpha being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-param_optim_upper"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-param_optim_upper}{}}}
\subsection{Method \code{param_optim_upper()}}{
Upper bounds of parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$param_optim_upper(p_est = self$p_est, s2_est = self$s2_est)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p_est}}{Is p being estimated?}

\item{\code{s2_est}}{Is s2 being estimated?}

\item{\code{alpha_est}}{Is alpha being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-set_params_from_optim"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-set_params_from_optim}{}}}
\subsection{Method \code{set_params_from_optim()}}{
Set parameters from optimization output
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$set_params_from_optim(
  optim_out,
  p_est = self$p_est,
  s2_est = self$s2_est
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{optim_out}}{Output from optimization}

\item{\code{p_est}}{Is p being estimated?}

\item{\code{s2_est}}{Is s2 being estimated?}

\item{\code{alpha_est}}{Is alpha being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-s2_from_params"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-s2_from_params}{}}}
\subsection{Method \code{s2_from_params()}}{
Get s2 from params vector
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$s2_from_params(params, s2_est = self$s2_est)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{parameter vector}

\item{\code{s2_est}}{Is s2 being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-plot"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-plot}{}}}
\subsection{Method \code{plot()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$plot(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-plotLatent"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-plotLatent}{}}}
\subsection{Method \code{plotLatent()}}{
Plot the points in the latent space
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$plotLatent()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-print"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-print}{}}}
\subsection{Method \code{print()}}{
Print this object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_LatentFactorKernel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_LatentFactorKernel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatentFactorKernel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
