% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSSTDA_objects.R
\name{geneSelection.default}
\alias{geneSelection.default}
\title{gene_selection_classes.default}
\usage{
\method{geneSelection}{default}(data_object, gen_select_type, percent_gen_select, na.rm = TRUE)
}
\arguments{
\item{data_object}{Object with:
\itemize{
\item full_data Input matrix whose columns correspond to the patients and
rows to the genes.
\item survival_time Numerical vector of the same length as the number of
columns of full_data. Patients must be in the same order as in full_data.
For the patients with tumour sample should be indicated the time between
disease diagnosis and death (if not dead until the end of follow-up)
and healthy patients must have an NA value.
\item survival_event Numerical vector of the same length as the number of
columns of full_data. Patients must be in the same order as in full_data.
For the patients with tumour sample should be indicated whether
the patient has died (1) or not (0). Only these values are valid
and healthy patients must have an NA value.
\item case_tag Character vector of the same length as the number of
columns of full_data. Patients must be in the same order as in full_data.
It must be indicated for each patient whether he/she is healthy or not.
One value should be used to indicate whether the patient is healthy and
another value should be used to indicate whether the patient's sample is
tumourous. The user will then be asked which one indicates whether
the patient is healthy. Only two values are valid in the vector in total.
}}

\item{gen_select_type}{Option. Options on how to select the genes to be
used in the mapper. Select the "Abs" option, which means that the
genes with the highest absolute value are chosen, or the
"Top_Bot" option, which means that half of the selected
genes are those with the highest value (positive value, i.e.
worst survival prognosis) and the other half are those with the
lowest value (negative value, i.e. best prognosis). "Top_Bot" default option.}

\item{percent_gen_select}{Percentage (from zero to one hundred) of genes
to be selected to be used in mapper. 10 default option.}

\item{na.rm}{\code{logical}. If \code{TRUE}, \code{NA} rows are omitted.
If \code{FALSE}, an error occurs in case of \code{NA} rows. TRUE default
option.}
}
\value{
A \code{geneSelection} object. It contains: the full_data without NAN's values,
the control tag of the healthy patient, the matrix with the normal space and
the matrix of the disease components.
}
\description{
Private function to select Gene without DGSA process
}
\examples{
\donttest{
data_object <- list("full_data" = full_data, "survival_time" = survival_time,
"survival_event" = survival_event, "case_tag" = case_tag)
class(data_object) <- "data_object"
geneSelection_object <- geneSelection(data_object, gen_select_type ="top_bot",
                                      percent_gen_select = 10)}
}
