% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distMat2Rank.R
\name{distMat2Rank}
\alias{distMat2Rank}
\title{distMat2Rank}
\usage{
distMat2Rank(mat, lower_is_closer = TRUE)
}
\arguments{
\item{mat}{A numerical matrix containing distances.}

\item{lower_is_closer}{Logical indicating that lower is closer.}
}
\value{
A symmetric matrix of scaled ranks (quantiles). The matrix has the attribute 'lower_is_closer' set to
'TRUE'.
}
\description{
Convert a symmetrical numerical matrix of distances to a matrix of ranks. Note: Only the lower
side of the matrix is used. Data on the upper right are assumed to be redundant.
}
\details{
This is used by default by gsnPareNetGenericHierarchic.
}
\examples{

# Start with a matrix of distances:
mat.dist <-  matrix( c( NA, -400, -600, NA, NA, -120, NA, NA, NA ), nrow = 3, ncol = 3 )
# Get the ranks as a matrix:
mat.ranks <- distMat2Rank(mat.dist)

# If, for this given metric, higher numbers are closer
# or more similar, do this instead:
mat.ranks2 <- distMat2Rank(mat.dist, lower_is_closer = FALSE)

}
\seealso{
\code{\link{distMat2UnitNormRank}()}
}
