% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grin.oncoprint.mtx.R
\name{grin.oncoprint.mtx}
\alias{grin.oncoprint.mtx}
\title{GRIN OncoPrint Matrix}
\usage{
grin.oncoprint.mtx(grin.res, oncoprint.genes)
}
\arguments{
\item{grin.res}{GRIN results (output of the grin.stats function).}

\item{oncoprint.genes}{Vector of ensembl IDs for the selected list of genes to be added to the OncoPrint.}
}
\value{
Function uses the output results of grin.stats function and return data table of lesions that affect a group of selected genes (each row is a gene and each column is a patient ID).
}
\description{
Function use GRIN results table and prepare the lesion matrix that the user can pass to the oncoprint function from ComplexHeatmap package to geneate an OncoPrint for a selcted list of genes.
}
\details{
Function will use the input list of ensembl IDs to prepare a data table of lesions that affect these genes (each row is a gene and each column is a patient ID). This lesion matrix is compatible and can be passed to oncoprint function in ComplexHeatmap library to prepare an OncoPrint for lesions in the selected list of genes.
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)
data(hg19.chrom.size)

# Run GRIN analysis using grin.stats function:
grin.results=grin.stats(lesion.data,
                        hg19.gene.annotation,
                        hg19.chrom.size)

# specify a list of genes to be included in the oncoprint (driver genes):
oncoprint.genes=as.vector(c("ENSG00000148400", "ENSG00000171862", "ENSG00000171843",
                            "ENSG00000156531", "ENSG00000162367", "ENSG00000096968",
                            "ENSG00000105639", "ENSG00000118513","ENSG00000102974",
                            "ENSG00000133703"))

# prepare the oncoprint lesion matrix:
oncoprint.mtx=grin.oncoprint.mtx(grin.results,
                                 oncoprint.genes)

# user can also specify a list of top significant genes in the GRIN constellation test:
# for example: select genes affected by two types of lesion with q2.nsubj<0.01:
genes.const = grin.results$gene.hits[grin.results$gene.hits$q2.nsubj < 0.01, ]
# get ensembl.ids for this list of genes
selected.genes=as.vector(genes.const$gene)
oncoprint.mtx.const=grin.oncoprint.mtx(grin.results,
                                       selected.genes)
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=grin.stats]{grin.stats()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
