% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.chrom.length.R
\name{get.chrom.length}
\alias{get.chrom.length}
\title{Get Chromosome Length}
\usage{
get.chrom.length(genome.assembly)
}
\arguments{
\item{genome.assembly}{User can specify one of four supported genome assemblies that include "Human_GRCh38", "Human_GRCh37", "Mouse_HGCm39" and "Mouse_HGCm38".}
}
\value{
A data table with the following two columns:
\item{chrom}{column has the chromosome number denoted as 1, 2, X, Y, etc..}
\item{size}{column has the chromosome size in base pairs.}
}
\description{
Retrieve chromosome size data from chr.info txt files available on the UCSC genome browser based on the user specified genome assembly.
}
\details{
Based on the genome assembly specified by the user, the function will directly retrieve chromosome size data from chr.info txt file available on the UCSC genome browser.
}
\examples{
# To retreive chromosome size data for hg19 genome assembly:
hg19.chrom.size=get.chrom.length("Human_GRCh37")
# "Human_GRCh38" can be used to retreive chromosome size data for hg38 genome assembly.
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[circlize:read.chromInfo]{circlize::read.chromInfo()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
