/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.threading;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.usadellab.trimmomatic.fastq.FastqParser;
import org.usadellab.trimmomatic.fastq.FastqRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserWorker
implements Runnable {
    public static final int BLOCKSIZE = 1000;
    private FastqParser parser;
    private ArrayBlockingQueue<List<FastqRecord>> parserQueue;
    private AtomicBoolean complete;

    public ParserWorker(FastqParser parser, ArrayBlockingQueue<List<FastqRecord>> parserQueue) {
        this.parser = parser;
        this.parserQueue = parserQueue;
        this.complete = new AtomicBoolean();
    }

    public boolean isComplete() {
        return this.complete.get();
    }

    @Override
    public void run() {
        try {
            ArrayList<FastqRecord> recs = new ArrayList<FastqRecord>(1000);
            while (this.parser.hasNext()) {
                recs.add(this.parser.next());
                if (recs.size() < 1000) continue;
                this.parserQueue.put(recs);
                recs = new ArrayList();
            }
            if (recs.size() > 0) {
                this.parserQueue.put(recs);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.complete.set(true);
            try {
                this.parserQueue.put(new ArrayList());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

